@extends('layouts.auth-login')

@section('content')
		<!-- *************
			************ Login container start *************
		************* -->
		<div class="login-container">

<div class="container-fluid h-100">

<!-- Row start -->
<div class="row no-gutters h-100">
	<div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
		<div class="login-about">
			
			<div id="carouselLockScreen" class="carousel slide carousel-login" data-bs-ride="carousel">
				<ol class="carousel-indicators">
					<li data-bs-target="#carouselLockScreen" data-bs-slide-to="0" class="active"></li>
					<li data-bs-target="#carouselLockScreen" data-bs-slide-to="1"></li>
					<li data-bs-target="#carouselLockScreen" data-bs-slide-to="2"></li>
				</ol>
				<div class="carousel-inner">
					<div class="carousel-item active">
						<div class="carousel-quotes">
							<p>“The happiest people don’t have the best of everything, they just make the best of everything.”</p>
						</div>
					</div>
					<div class="carousel-item">
						<div class="carousel-quotes">
							<p>“The only way to do great work is to love what you do. If you haven’t found it yet, keep looking. Don’t settle.”</p>
						</div>
					</div>
					<div class="carousel-item">
						<div class="carousel-quotes">
							<p>“Think big and don’t listen to people who tell you it can’t be done. Life’s too short to think small.”</p>
						</div>
					</div>
				</div>
				<a class="carousel-control-prev" href="#carouselLockScreen" role="button" data-bs-slide="prev">
					<span class="carousel-control-prev-icon" aria-hidden="true"></span>
					<span class="visually-hidden">Previous</span>
				</a>
				<a class="carousel-control-next" href="#carouselLockScreen" role="button" data-bs-slide="next">
					<span class="carousel-control-next-icon" aria-hidden="true"></span>
					<span class="visually-hidden">Next</span>
				</a>
			</div>

		</div>
	</div>
				<div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
					<div class="login-wrapper">
                    <form method="POST" action="{{ route('login') }}">
						@include('inc.errorfile')
                        @csrf
							<div class="login-screen">
								<div class="login-body">
									<a href="#">
										<img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:90px;">
									</a>
									<h6>Welcome back<br>Please login to your account.</h6>
									<div class="field-wrapper">
										<input type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
										<div class="field-placeholder">Email ID</div>
									</div>



									<div class="field-wrapper mb-3">
                                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
										<div class="field-placeholder">Password</div>
									</div>

                                    <div class="field-wrapper mb-3">
                                        <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>

                                        <label class="form-check-label" for="remember">
                                            {{ __('Remember Me') }}
                                        </label>
                                        </div>
									</div>

									<div class="actions">
										<button type="submit" class="btn btn-primary">Login</button>
									</div>
								</div>
								
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Row end -->

		
			</div>
		</div>
		<!-- *************
			************ Login container end *************
		************* -->

@endsection

