@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Category</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('category.store')}}">
                @csrf   
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="category_name" required>
                                <div class="field-placeholder">Category Name</div>
                                <div class="valid-feedback">Looks good!</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Categories</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Category Name</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($categories as $category)
                        <tr>
                        <td>{{$category->category_name}}</td>
                        <td><a onclick="DeleteCategory(this.id)"  id="{{$category->id}}" href="#" class="btn btn-outine-danger btn-sm"><i class="icon-trash-2"></i></a></td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>
    function DeleteCategory(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete Category!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/category/delete/" + id;
            }
            })
    }
</script>

@endsection