@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">



    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                 <div class="card-header">
                    <div class="card-title">Customer Statement</div>
                </div>
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>Entered By</th>
                                <th>Last Purc. Branch</th>
                                <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($customers as $customer)
                                <tr>
                                <td>{{@strtoupper($customer->customer_name)}}</td>
                                <td>{{$customer->customer_phone}}</td>
                                <td>{{@strtoupper($customer->customer_address)}}</td>
                                <td>{{@strtoupper($customer->customer_enteredby)}}</td>
                                <td>{{@strtoupper($customer->customer_branch)}}</td>
                                <td>
                                <div class="actions">
                                    
                                    <a href="{{route('index.customer', $customer->id)}}" target="_blank"  title="Customer statement">
                                         <i class="icon-book-open text-danger" aria-hidden="true"></i>
                                    </a>
                                </div>
                                </td>
                                </tr>
                            @endforeach
                            </tbody>
                    </table>

                    {{$customers->links()}}
                    </div>
                    
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

    <script>
        function DeleteCustomer(id)  {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'Customer Data Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-customer/"+id);
                xhttp.send();
            }
            })
            
        }
    </script>

</div>
<!-- Content wrapper end -->

@endsection