@if($remarking->count() == 0)
<div class="alert alert-primary" role="alert">
  No Review Yet
</div>
@else
<div class="table-responsive">
<table class="table table-hover table-bordered m-0">
  <thead>
    <tr>
      <th scope="col">Order ID</th>
      <th scope="col">Remark</th>
      <th scope="col">Remark Category</th>
      <th scope="col">PIZZAMAN Review</th>
      <th scope="col">CHICKENMAN Review</th>
      <th scope="col">Regular Call?</th>
      <th scope="col">Action</th>
    </tr>
  </thead>
  <tbody>
    @foreach($remarking as $remark)
    <tr>
      <th scope="row">#{{$remark->order_number}}</th>
      <td>{{$remark->remark}}</td>
      <td>{{$remark->remark_category}}</td>
      <td>{!!$remark->remark_pizzaman == null ? '<strong>'."NO REMARK".'</strong>' : $remark->remark_pizzaman!!}</td>
      <td>{!!$remark->remark_chickenman == null ? '<strong>'."NO REMARK".'</strong>' : $remark->remark_chickenman !!}</td>
      <td>{{$remark->remark_call}}</td>
      <td><button class="btn btn-light btn-sm" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop{{$remark->id}}">
        Preview</button></td>
    </tr>
    @endforeach
  </tbody>
</table>
</div>
@endif




@foreach($remarking as $remarks)
<!-- Modal start -->
<div class="modal fade" id="staticBackdrop{{$remarks->id}}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">CHANGE REVIEW: {{$remarks->order_number}}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">

        <form action="{{route('updateRemark', $remarks->id)}}" method="POST">
                @csrf
                    <input type="text" name="order" value="{{$remarks->order_number}}" hidden>
                    <input type="text" name="customer_id" value="{{$customer->id}}" hidden>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea class="form-control" rows="2" name="remark">
                                      {{$remarks->remark}}
                                    </textarea>
                                    <div class="field-placeholder">Customer Remark <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            
                                    <!-- Row start -->
                                    <div class="row gutters" id="first-tab-label">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <select name="remark_category" class="form-control">
                                            <option disabled selected>Select option</option>
                                            <option>VERY SATISFIED</option>
                                            <option>COUNTER OR FLOOR</option>
                                            <option>CALL CENTER</option>
                                            <option>PACKAGING</option>
                                            <option>DISPATCH</option>
                                            <option>DELIVERY</option>
                                            <option>KITCHEN</option>
                                            <option>CLEANING</option>
                                            <option>CHAT BOT</option>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="icon-edit-3"></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">Remark Category <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                    <select name="remark_pizzaman" class="form-control">
                                            <option disabled selected>Select option</option>
                                            @foreach($pizzaman_remark as $remark)
                                            <option>{{$remark}}</option>
                                            @endforeach
                                        </select>
                                        <span class="input-group-text">
                                            <i class="icon-edit-3"></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">PIZZAMAN Remark</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                    <select name="remark_chickenman" class="form-control">
                                            <option disabled selected>Select option</option>
                                            @foreach($chickenman_remark as $remark)
                                            <option>{{$remark}}</option>
                                            @endforeach
                                        </select>
                                        <span class="input-group-text">
                                            <i class="icon-edit-3"></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">CHICKMAN Remark</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                    <select name="contact_status" id="" class="form-control">
                                    <option disabled selected>Select option</option>
                                            <option>SAVED</option>
                                            <option>ALREADY SAVED</option>
                                            <option>UNSAVED</option>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="icon-edit-3"></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">Contact Status</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>


                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                    <select name="remark_call" class="form-control">
                                    <option disabled selected>Select option</option>
                                            <option>YES</option>
                                            <option>NO</option>>
                                        </select>
                                        <span class="input-group-text">
                                            <i class="icon-edit-3"></i>
                                        </span>
                                    </div>
                                    <div class="field-placeholder">Regular Phone Call</div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>

                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <button class="btn btn-primary mt-2">Save Changes</button>
                            </div>
                </div>
                
            </form>



      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
      </div>
    </div>
  </div>
  @endforeach
  <!-- Modal end -->




<script>
  function preview(id) {
        const xhttp = new XMLHttpRequest();
        xhttp.onload = function() {
            data =  JSON.parse(this.responseText)
            document.getElementById("review_id").value = data.id;
        }
        xhttp.open("GET", "/ceqa-dashboard/preview-review/"+id);
        xhttp.send();
  }
</script>