@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Customer List</h5>
                    <p>Customer Records and Transactions, you can view all transactions by customer</p>
                    <a href="{{route('showNewAndTransactions')}}" style="text-decoration:underline">View Customer Transactions Today</a>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Add Customer</h5>
                    <p>This section allows you to add or import new customer to the system by clicking Add customer or or using the import field.</p>
                   <hr>
                    <form class="row gutters" method="post" action="{{route('importCustomer')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">														
                                    <input type="file" name="file" class="form-control" id="inputGroupFile01">
                                    <button class="btn btn-outline-primary" type="submit" required>Upload</button>
                                </div>
                                <div class="field-placeholder">Import Customers</div>
                                <small class="text-primary"> <a href="/uploads/customers.csv">Download Sample csv</a></small>
                            </div>
                            <!-- Field wrapper end -->
                            

                        </div>
                    </form>
                </div>
                <button class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#submitTicketModal"><i class="icon-user-plus"></i>Customer</button>
                @include('modal.customer-data')
            </div>

            
        </div>
    </div>
    <!-- Row end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>EnteredBy</th>
                                <th>Last Purc. Branch</th>
                                <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($customers as $customer)
                                <tr>
                                <td>{{@strtoupper($customer->customer_name)}}</td>
                                <td>{{$customer->customer_phone}}</td>
                                <td>{{@strtoupper($customer->customer_address)}}</td>
                                <td>{{@strtoupper($customer->customer_enteredby)}}</td>
                                <td>{{@strtoupper($customer->customer_branch)}}</td>
                                <td>
                                <div class="actions">
                                    @if($customer->customer_name !== "WALK-IN CUSTOMER")
                                    <a href="{{route('orders.customer', encrypt($customer->id))}}" title="view All">
                                    <i class="icon-eye1" aria-hidden="true"></i>
                                    </a>
                                    @endif
                                    @if($customer->customer_name == "WALK-IN CUSTOMER")
                                    <a href="#" data-toggle="tooltip"d ata-placement="top" title="" data-original-title="LOCK">
                                        <i class="icon-lock1 text-danger"></i>
                                    </a>
                                    @else
                                    <a href="#" data-toggle="tooltip" onclick="DeleteCustomer(this.id)" id="{{$customer->id}}" data-placement="top" title="" data-original-title="Delete">
                                        <i class="icon-x-circle text-danger"></i>
                                    </a>

                                    @endif
                                </div>
                                </td>
                                </tr>
                            @endforeach
                            </tbody>
                    </table>

                    {{$customers->links()}}
                    </div>
                    
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

    <script>
        function DeleteCustomer(id)  {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'Customer Data Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-customer/"+id);
                xhttp.send();
            }
            })
            
        }
    </script>

</div>
<!-- Content wrapper end -->

@endsection