@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Customer list for {{!request('date') ? "today" : request('date')}}</h5>
                    <p>Customer purchases {{!request('date') ? "today" : request('date')}},you can view customer profile and transactions.</p>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Register Customer</h5>
                    <p>Click 'Add Customer' to register a new customer </p>
                </div>
                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#submitTicketModal"><i class="icon-plus" aria-hidden="true"></i>Add Customer</button>
                <div class="modal fade" id="submitTicketModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="submitTicketModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="submitTicketModalLabel">New Customer</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form class="row gutters" method="post" action="{{route('customer')}}">
                                    @csrf
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" name="customer_name" placeholder="Enter customer name">
                                            <div class="field-placeholder">Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                        <textarea name="customer_address" cols="30" rows="5"></textarea>
                                            <div class="field-placeholder">Address</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="field-wrapper">
                                                <input type="text" class="form-control" name="customer_phone" placeholder="Enter Phone Number">
                                                <div class="field-placeholder">Contact</div>
                                            </div>
                                        </div>
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="field-wrapper">
                                                <input type="text" readonly class="form-control" value="{{auth()->user()->name}}" name="customer_enteredby" placeholder="Entered by">
                                                <div class="field-placeholder">Entered by</div>
                                            </div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper m-0">
                                            <textarea class="form-control" name="customer_note" rows="3"></textarea>
                                            <div class="field-placeholder">Note</div>
                                        </div>
                                        <!-- Field wrapper end -->

                                        
                                        <div class="field-wrapper m-0">
                                        <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </div>

                                    
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('customerReportDate')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn btn-primary"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                    </form>




    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>EnteredBy</th>
                                <th>Last Purc. Branch</th>
                                <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($customer_data as $customer_data)
                                <tr>
                                <td>{{@strtoupper($customer_data->customer_name)}}</td>
                                <td>{{$customer_data->customer_phone}}</td>
                                <td>{{@strtoupper($customer_data->customer_address)}}</td>
                                <td>{{@strtoupper($customer_data->customer_enteredby)}}</td>
                                <td>{{@strtoupper($customer_data->customer_branch)}}</td>
                              
                                <td>
                                <div class="actions">
                                    <a href="{{route('orders.customer', encrypt($customer_data->id))}}" title="view All">
                                    <i class="icon-eye1" aria-hidden="true"></i>
                                    </a>
                                    @if($customer_data->customer_name !== "WALK-IN CUSTOMER")
                                    <a href="#" data-toggle="tooltip" onclick="DeleteCustomer(this.id)" id="{{$customer_data->id}}" data-placement="top" title="" data-original-title="Delete">
                                        <i class="icon-x-circle text-danger"></i>
                                    </a>
                                    @endif
                                </div>
                                </td>
                                </tr>
                            @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

    <script>
        function DeleteCustomer(id)  {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'Customer Data Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-customer/"+id);
                xhttp.send();
            }
            })
            
        }
    </script>

</div>
<!-- Content wrapper end -->

@endsection