@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-user1"></i>
                </div>
                <div class="sale-details">
                    <h2>{{$customer_total->count()}}</h2>
                    <p>Customers</p>
                </div>
            </div>
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-shopping-bag1"></i>
                </div>
                <div class="sale-details">
                    <h2>{{$orders_total->count()}}</h2>
                    <p>Orders</p>
                </div>
            </div>
        </div>
        <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-tonality"></i>
                </div>
                <div class="sale-details">
                    <h2>@convert($total_orders)</h2>
                    <p>Revenue</p>
                </div>
            </div>
            <div class="stats-tile2">
                <div class="sale-icon">
                    <i class="icon-box"></i>
                </div>
                <div class="sale-details">
                    <h2>{{$products->count()}}</h2>
                    <p>Products</p>
                </div>
            </div>
        </div>

        
        <div class="col-xl-8 col-lg-6 col-md-12 col-sm-12 col-12">
            <div style="margin-bottom:12px">
                 <a href="{{route('websitereview.index')}}" class="btn btn-outline-primary rounded-pill">Walk-In Customer Reviews</a>
            </div>
            <div class="card">
                <div class="card-header">
                    <div class="card-title">PIZZAMAN CLASSIFICATION</div>
                    
                </div>
                <div class="card-body">
                   
            <div class="table-responsive">
                <table class="table table-hover table-bordered m-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Pizzaman Classification</th>
                            <th>Total Count</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($remark_pizzaman as $remark)
                        <tr>
                            <td>{{$loop->iteration}}</td>
                            <td><span class="badge bg-danger">{{$remark->remark_pizzaman}}</span></td>
                            <td>{{$remark->total_class}}</td>
                            <td><a href="{{route('reviewCategoryDepartment', $remark->remark_pizzaman)}}">view</a></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
                </div>
                
            </div>





            <div class="card">
                <div class="card-header">
                    <div class="card-title">CHICKENMAN CLASSIFICATION</div>
                    
                </div>
                <div class="card-body">
                   
            <div class="table-responsive">
                <table class="table table-hover table-bordered m-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Chickenman Classification</th>
                            <th>Total Count</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($remark_chickenman as $remark)
                        <tr>
                            <td>{{$loop->iteration}}</td>
                            <td><span class="badge bg-danger">{{$remark->remark_chickenman}}</span></td>
                            <td>{{$remark->total_class}}</td>
                            <td><a href="{{route('reviewCategoryDepartmentChicken', $remark->remark_chickenman)}}">view</a></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
                </div>
            </div>

        
        </div>

        
        
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <div class="card">
                <div class="card-header">
                    <div class="card-title">Review Category Count</div>
                </div>
                <div class="card-body">
                    <div class="stats-tiles-list">
                        @foreach( $remark_category as $remark_category)
                        <a href="{{route('reviewCategory', $remark_category->category)}}" class="tiles-list">
                            <img src="/img/food/pizza.svg" alt="Pizzas">
                            <h2>{{$remark_category->total_remarks}}</h2>
                            <p>{{$remark_category->category}}</p>
                        </a>
                        @endforeach
                    </div>
                </div>
            </div>

        </div>

        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">

            <div class="card  h-380">
                <div class="card-header">
                    <div class="card-title">Top Customers</div>
                </div>
                <div class="card-body">

                    <div class="top-users-container">
                        @foreach($top_customers as $customer)
                        <div class="top-user">
                            <img src="/img/user8.png" class="avatar" alt="Agent">
                            <div class="user-details">
                                <h6>{{$customer->name}}</h6>
                                <div class="rank"> Accu. Purchases: {{empty($app->currency) ? "GHS" : $app->currency}}@convert($customer -> total)</div>
                                <div class="user-score">
                                    <div class="progress">
                                        <div class="progress-bar bg-primary" role="progressbar" style="width: 87%" aria-valuenow="87" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <div class="rank">Rank #{{$loop->iteration}} | <a href="{{route('orders.customer', $customer->id)}}">view Transactions</a></div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                </div>
            </div>

        </div>
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">

            <div class="card h-380">
                <div class="card-header">
                    <div class="card-title">Reviews</div>
                </div>
                <div class="card-body">
                    <ul class="customer-rating">
                        @foreach($review as $reviews)
                        <li class="clearfix">
                        <div class="customer">
                                <img src="/img/user3.png" alt="Uni Pro Admin">
                            </div>
                            <div class="customer-review">
                                <div class="stars" id="rate2"></div>
                                <h5>{{$reviews -> customer_branch}}</h5>
                                <h6 class="by">By, <a href="{{route('orders.customer', $customer->id)}}">{{$reviews->customer_name}}</a></h6>
                                <p>{{$reviews->remark}}</p>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection