@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
@if(auth()->user()->role == "Administrator")

<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">

<form action="{{route('LoyaltySubmit')}}">
        <!-- Field wrapper start -->
    <div class="field-wrapper">
        <div class="input-group">
            <input type="text" name="amount" class="form-control" placeholder="Amount" value="{{empty($loyalty->amount) ? 0 : $loyalty->amount}}">
            <span class="input-group-text">:</span>
            <input type="text" name="loyalty_amount" value="{{empty($loyalty->point_amount) ? 0 : $loyalty->point_amount}}" class="form-control" placeholder="Loyalty Amount & Point">
        </div>
        <div class="field-placeholder">Loyalty Ratio</div>
    </div>
    <!-- Field wrapper end -->
    <button class="btn btn-primary btn-sm" type="submit"><i class="icon-save1"></i>save</button>
</form>
</div>	

@endif
<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
<div class="graph-card">
    <h6>Customers</h6>
    <h4>@convert(\DB::table('customers')->count())</h4>
    <div class="custom-btn-group mt-2">
    <button class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#scheduleModal"><i class="icon-search"></i>Search Customer</button> 
    <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#submitTicketModal"><i class="icon-user-plus"></i>Add</button> 
    @include('modal.customer-data')

</div>
</div>
</div>
<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
<div class="payments-card">
    <!-- Field wrapper start -->
    <div class="field-wrapper">
        <div class="checkbox-container">
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" id="chcekEmail" value="option1">
                <label class="form-check-label" for="chcekEmail">Yes, enable</label>
            </div>
            
            <div class="field-placeholder">Enable loyalty points for transations</div>
        </div>
    </div>
    <!-- Field wrapper end -->
    <h6>Loyalty Points Balance</h6>
    <h4>{{empty($app->currency) ? "GHS" : $app->currency}}@convert(\DB::table('loyalty_points')->sum('increase') - \DB::table('loyalty_points')->sum('decrease'))</h4>
    <div class="custom-btn-group mt-2">
        <!-- <button class="btn btn-outline-primary"  onclick="resetPoints()"><i class="icon-restore"></i>Reset Point</button> -->
    </div>
</div>
</div>
</div>
<!-- Row end -->


<!-- Card start -->
<div class="card">
    <div class="card-header">
        <div class="card-title">Top-Rated Customer</div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="copy-print-csv" class="table custom-table">
                <thead>
                    <tr>
                    <th>Name</th>
                    <th>Total Points</th>
                    <th>Loyalty Code</th>
                    <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($loyalty_points as $loyalty_points)
                    @if($loyalty_points->customer_name == "WALK-IN CUSTOMER")
                                                    @continue
                                                @endif
                    <?php $balance_transaction = 
                        \DB::table('loyalty_points')->where('customer_id', $loyalty_points->id)->sum('increase') -
                        \DB::table('loyalty_points')->where('customer_id', $loyalty_points->id)->sum('decrease');
                        ?>
                    <tr>
                    <td>{{$loyalty_points->customer_name}}</td>
                    <td>@convert($balance_transaction)</td>
                    <td>LT{{$loyalty_points->customer_phone}}</td>
                    <td>
                        <a href="{{route('index.customer', $loyalty_points->id)}}" class="btn btn-outline-primary btn-sm">
                                <i class="icon-gift"></i>Redeem
                                </a>
                            </td>
                    </tr>
                    @endforeach
                </tbody>
        </table>
        </div>
    </div>
</div>
<!-- Card end -->


</div>
</div>
<!-- Content wrapper end -->



<!-- Modal start -->
<div class="modal fade" id="scheduleModal" tabindex="-1" aria-labelledby="scheduleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="scheduleModalLabel">Customer Advanced Search</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
               <form action="{{route('searchCustomer')}}" method="get">
                    <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">														
                        <input type="text" class="form-control" required name="customer" placeholder="search by name, loyalty code, phone number, last outlet of purchase">
                        <button class="btn btn-primary" type="submit">Search</button>
                    </div>
                    <div class="field-placeholder">Search Customer</div>
                </div>
                <!-- Field wrapper end -->
               </form>

            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<script>
    function resetPoints() {
        Swal.fire({
                title: 'Are you sure?',
                text: "Are you sure reset all loyalty point to 0?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, reset points!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('resetPoints')}}";
                }
                })
    }
</script>




@endsection