@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

    
<!-- Row start -->
<div class="row gutters">
        <div class="d-flex justify-content-between">
        <h6 class="mb-2" style="font-weight:400"> Welcome Back, {{@ucwords(@strtolower(auth()->user()->name))}}!</h6>
        
            <span> <a href="{{route('UserActivity.index')}}">Audit Log</a> </span>
        </div>
        
    </div>
    <!-- Row end -->


    	<!-- Row start -->
        <div class="row gutters">
							<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
								<div class="stats-tile">
									<div class="sale-icon">
										<i class="icon-package"></i>
									</div>
									<div class="sale-details">
										<h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($salesToday = $sales - $discount)</h2>
										<p>Sales</p>
									</div>
									<div class="sale-graph">
										<div id="sparklineLine1"></div>
									</div>
								</div>
							</div>
							<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
								<div class="stats-tile">
									<div class="sale-icon">
										<i class="icon-shopping-bag1"></i>
									</div>
									<div class="sale-details">
										<h2>{{$orders}}</h2>
										<p><a href="{{route('AllOrders')}}">Transactions</a></p>
									</div>
									<div class="sale-graph">
										<div id="sparklineLine2"></div>
									</div>
								</div>
							</div>
							<div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
								<div class="stats-tile">
									<div class="sale-icon">
										<i class="icon-droplet"></i>
									</div>
									<div class="sale-details">
										<h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($salesToday/($orders == 0 ? 1 : $orders))</h2>
										<p>Avg. Transaction value</p>
									</div>
									<div class="sale-graph">
										<div id="sparklineLine3"></div>
									</div>
								</div>
							</div>
						</div>
						<!-- Row end -->

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title" style="font-weight:400">best selling outlets</div>
                    <div class="graph-day-selection" role="group">
                        <button type="button" class="btn active">Today</button> 
                    </div>
                </div>
                <div class="card-body">
                    <div id="sales"></div>
                    <span class="text-light" style="float:right"><em><small>Note: discounts excluded</small></em></span>
                </div>
            </div>
        </div>

        

        <div class="col-xl-4 col-lg-6 col-md-6 col-sm-6 col-12">
            <div class="card">

												
												


            <?php $branch = \DB::table('branches')->pluck('branch_name') ?>

            <div style="padding:18px">
            <form action="{{route('branchSales')}}" method="get">
            <!-- Field wrapper start -->
            <div class="field-wrapper">
                <div class="input-group">														
                <select class="form-control @error('branch') is-invalid @enderror js-states"  required name="branch">
                    @if(auth()->user()->role == "Administrator")
                    <option disabled selected>Select Outlet</option>
                        @foreach($all_branch as $branch)
                        <option value="{{encrypt($branch)}}">{{$branch}}</option>
                        @endforeach
                    @else
                        <option selected value="{{encrypt(auth()->user()->branch)}}">{{auth()->user()->branch}}</option>
                    @endif
                </select>
                    <button class="btn btn-primary">Generate</button>
                </div>
                <div class="field-placeholder">Sales Breakdown</div>
            </div>
            <!-- Field wrapper end -->
            </form> 
            
            
            <span><i class="icon-link2"></i> QUICK LINKS</span>

            <div class="card-body">
                    
                <div class="d-grid gap-2">
                @if(auth()->user()->role == "Administrator")
                    <a class="btn btn-outline-info" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#addNewDocument33"><i class="icon-plus"></i> Add Product</a>
                    @endif
                    <a class="btn btn-outline-light" href="{{ auth()->user()->role == "Administrator" ? route('BookkeepingRe') : route('salesReport')}}"> Reporting</a>
                    <a class="btn btn-outline-light" href="{{route('showCustomer')}}"> Customers</a>
                    <a class="btn btn-outline-light" href="{{route('HeldTransaction')}}"> Held Transactions</a>
                    <a href="{{route('IncomingRequest')}}" class="btn btn-outline-light"> Incoming Request ({{$requisition_list->count()}})</a>
                    <a class="btn btn-outline-light" href="{{route('voucherIncoming')}}"> Incoming Vouchers ({{$transferCount->count()}})</a>
                    @if(auth()->user()->role == "Administrator")
                    <a class="btn btn-outline-light" href="{{route('voucherAuthorize')}}">  My Approvals ({{$authorizeStatus->count()}})</a>
                    @endif
                </div>

                </div>
                </div>


    
                
            </div>
        </div>
       
        
    </div>
    <!-- Row end -->




<!-- Row start -->
<div class="row gutters">

<div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
    <div class="stats-tile2">
        <div class="sale-icon">
            <i class="icon-question_answer"></i>
        </div>
        <div class="sale-details">
            <p>Get Started FAQ</p>
        </div>
    </div>
    <div class="stats-tile2">
        <div class="sale-icon">
            <i class="icon-local_library"></i>
        </div>
        <div class="sale-details">
            <p>Knowledge Articles</p>
        </div>
    </div>
</div>
<div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
    <div class="stats-tile2">
        <div class="sale-icon">
            <i class="icon-video"></i>
        </div>
        <div class="sale-details">
            <p>Video Tutorial</p>
        </div>
    </div>
    <div class="stats-tile2">
        <div class="sale-icon">
            <i class="icon-headphones"></i>
        </div>
        <div class="sale-details">
        <p><a href="mailto:info@andasconsult.com">Customer Support</a></p>
        </div>
    </div>
</div>
<div class="col-xl-8 col-lg-6 col-md-12 col-sm-12 col-12">

    <div class="card">
        <div class="card-header">
            <div class="card-title">Incoming Voucher</div>
            <div class="graph-day-selection" role="group">
                        <a href="{{route('voucherIncoming')}}"> Export Vouchers</a>
                    </div>
        </div>
        <div class="card-body">
        <div class="table-responsive">
                    <div class="table-container light-blue">
									<table class="table v-middle m-0">
                            <thead>
                                <tr>
                                <th>Trans. No.</th>
                                <th>Trans. Date</th>
                                <th>Transfer from</th>													  
                                <th>By User</th>													  
                                <th>Status</th>
                                <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($transferCount->chunk(3) as $row)
                                @foreach($row as $list)
                                <?php $status = \DB::table('issue_lists')->where('transaction_no', $list->transaction_no)->first();  ?>
                                <tr>
                                    <td>
                                    #{{$list->transaction_no}}
                                    </td>
                                    <td>
                                        {{$list->issue_date}}
                                    </td>
                                    <td>
                                    {{@ucwords(@strtolower($list->issue_from))}}
                                    </td>													  
                                    <td>{{@ucwords(@strtolower($list->name))}}</td>
                                    <td>
                                        @if($list->issue_status == 0)
                                        <span class="badge bg-success"> Rejected </span>
                                        @elseif($list->issue_status == 1)
                                        <span class="badge bg-danger"> Accepted </span>
                                        @else
                                        <span class="badge bg-info"> Pending </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($status->authorize_status == 1)
                                        <div class="actions">
                                            <a href="{{route('viewVoucher', $list->transaction_no)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                                <i class="icon-edit1 text-info"></i>
                                            </a>
                                        </div>
                                        @elseif($status->authorize_status == 0)
                                            <span class="badge bg-danger"> Rejected </span>
                                        @else
                                            <span class="badge bg-secondary"> Awaiting Approval </span>
                                        @endif
                                    </td>
                             </tr>
                            @endforeach
                            @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
        </div>
    </div>

</div>
<!-- Row end -->
</div>

</div>
<!-- Content wrapper end -->


@include('inc.add-product')


@endsection