<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Title -->
		<title>Kitchen display ~ {{auth()->user()->branch}}</title>

		 <!-- Date Range CSS -->
         <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

            <!-- Uploader CSS -->
            <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

            <!-- *************
                ************ Common Css Files *************
            ************ -->
            <!-- Bootstrap css -->
            <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

            <!-- Icomoon Font Icons css -->
            <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

            <!-- Main css -->
            <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">


            <!-- Data Tables -->
            <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
            <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
            <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

            <!-- Sweet Alert-->
            <link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


            <script src="{{asset('assets/js/ajax.min.js')}}"></script>

            <!-- *************
                ************ Vendor Css Files *************
            ************ -->

            <!-- Bootstrap Select CSS -->
            <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

            <!-- Mega Menu -->
            <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

            <!-- Search Filter JS -->
            <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
            <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>
	<body>

    <style>
        body{
            background-color: #cbd4fe;
        }

    </style>


<!-- Row start -->
<div class="row gutters" id="main">

<div class="breadcrumb-container" style="background-color:#ffffff; box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);">
 <img src="/assets/img/{{$app->fav_icon}}" alt="Logo" style="max-height:45px"> 
<span>
<!-- <a href="#" class="btn btn-outline-primary" onclick="CompleteTransaction()"><i class="icon-cancel"></i> Clear Transactions</a> -->
<a href="/" class="btn btn-outline-primary"><i class="icon-arrow_back"></i> Back</a>
</span>

<span style="float:right; padding:10px" class="text-primary">
    ORDER DISPLAY | {{auth()->user()->branch}} [{{auth()->user()->name}}]
</span>

</div>
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-body">

                <!-- Row start -->
                <div class="row gutters">
                @foreach($order as $number => $item)
                    <div class="col-lg-4 col-md-4 col-sm-12">

                    <?php $customer = \DB::table('orders')->where('order_id', $number)->first();

                        // $customer_details = \DB::table('customers')->where('id', $customer->customer_id)->first();
                    
                    ?>
                        
                        <!-- Pricing plan start -->
                        <div class="pricing-plan">
                            <div class="pricing-header">
                                <div class="pricing-cost">{{ substr($number, -3) }}
                            </div>
                            </div>
                            <div class="pricing-body">
                                <ul class="pricing-features">
                                @foreach($item as $item)
                                    <li style="font-size:20px">@convert($item->invoice_quantity) PCS / <strong>{!!$item->invoice_product_name!!}</strong> @ {{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->invoice_total_price)</li>
                                @endforeach
                                </ul>
                                <div style="margin-left:10px"><?=  \Carbon\Carbon::parse($item->created_at)->diffForHumans() ?> 
                            </div>
                                <div class="pricing-footer">
                                    <a href="#" class="btn btn-primary btn-lg">{{$customer->order_type == null ? "UNASSIGNED" : $customer->order_type}}</a>
                                    <button onclick="CompleteTransaction(this.id)" id="{{$item ->invoice_number}}" class="btn btn-outline-primary btn-lg">Order is Ready</button>
                                </div>
                            </div>
                        </div>
                        <!-- Pricing plan end -->

                    </div>
                    @endforeach
                    
                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->




<!-- Sweet Alerts js -->
<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>

    <script>
        function CompleteTransaction(id) {
            Swal.fire({
                title: 'Mark Order as Ready?',
                text: "You are about to mark the order as ready. This action is irreversible. Are you sure you want to proceed?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Ready!'
                }).then((result) => {
                if (result.isConfirmed) {
                    const xhttp = new XMLHttpRequest();
                    xhttp.onload = function() {
                        Swal.fire(
                        'Marked Ready!',
                        'The order will clear from screen',
                        'success'
                        )
                    }
                    xhttp.open("GET", "/dashboard/complete/complete-transaction-waiting/" + id);
                    xhttp.send();
                }
                })
        }



        function markReady(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "Do you want to make it ready for pick up",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, make it ready for pick up!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/dashboard/complete/complete-transaction-waiting-ready/" + id
                    Swal.fire(
                    'Order Loading, Please wait',
                    'Order will show soon',
                    'success'
                    )
                }
                })
        }
        
    </script>




    @include('inc.check-internet')





    		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->
		
		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>