@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Coupons </div>
                </div>
                <div class="card-body">
                    <!-- Row start -->
                    <div class="table-responsive">
                    <table id="fixedHeader" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Description</th>
                            <th>Barcode</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($celebrity as $celeb)
                        <tr>
                            <td>{{$celeb->discount_code}}
                                <p>Discount: {{$celeb->discount_percentage}}%</p>
                            </td>
                            <td>{{$celeb->discount_holder_name}}</td>
                            <td>{!! empty($celeb->discount_barcode) ? '<span class="badge rounded-pill bg-primary">'. "None" .'</span>' : '<span class="text-primary">' .$celeb->discount_barcode.'</span>'!!}</td>
                            <td>
                            <div class="actions">
                                <a href="{{route('celebRecords',$celeb->discount_code)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="#" data-toggle="tooltip" id="{{$celeb->id}}" onclick="DeleteDiscount(this.id)" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Coupon</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form id="celebdiscount">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="discount_code">
                                <div class="field-placeholder">Coupon Code<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input required class="form-control" type="number" step="0.01" name="discount_percentage">
                                <div class="field-placeholder">Amount / % <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="discount_holder_name">
                                <div class="field-placeholder">Description<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" type="text" name="barcode" onKeydown="return event.key != 'Enter';">
                                <div class="field-placeholder">Discount Barcode</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script type="text/javascript">
    
    $("#celebdiscount").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.celebdiscount')}}",
                dataType: "json",
                data: $('#celebdiscount').serialize(),
                success: function(data){
                    $("#celebdiscount")[0].reset();
                    $("#copy-print-csv").load(" #copy-print-csv");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New discount added Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });




        function DeleteDiscount(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "you are deleting a coupon. you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'coupon deleted successfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/dashboard/celeb-discount/delete/"+id);
                xhttp.send();
            }
            })
            
        }
</script>


@endsection