@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

   <!-- Row start -->
   <div class="row gutters">
    <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <h5 class="m-0">Welcome Back, {{auth()->user()->name}}! </h5> 
        <small>Logged In at: <b class="text-primary">{{ \Carbon\Carbon::parse(auth()->user()->last_seen)->diffForHumans() }}</b>,
        Active Date: {{$dayClose->day_close}},
        Outlet: {{auth()->user()->branch}}

        </small>

        <!-- Consultants banner start -->
        <div class="consulting-banner">
            <div class="consulting-banner-bg"></div>
            <div class="consulting-body">
                <div class="consulting-content">
                    <h4>{{$app->app_name}} DELIVERY TRACKER!</h4>
                    <p>Manage All Deliveries,  Track deliveries <br />generate report on delivery orders and more. it's easy!</p>
                </div>
            </div>
        </div>
        <!-- Consultants banner end -->
        
    </div>

    <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <!-- Consultants card start -->
        <div class="consulting-card">
            <div class="consulting-card-bg"></div>
            <div class="consulting-card-body">
                <h4>Order transfer</h4>
                <p>Easily transfer orders to other outlets. Click to get started</p>
                <a href="{{route('TransferOrder')}}" class="btn btn-primary stripes-btn">Make transfer</a>
            </div>
        </div>
        <!-- Consultants card end -->
        
    </div>
</div>
<!-- Row end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    @if(!empty(request('search')))
                        <div class="search-results-header">
                            <span><h3>Results:'....{{request('search')}}</h3></span>
                        </div>
                        @else
                        <div class="card-title">Pending Orders</div>
                    @endif
                    <div style="float:right; margin:10px">
                    <a class="btn btn-outline-info" href="{{route('ProcessingTransactions')}}"> <i class="icon-directions_car"></i> Dispatching Orders</a>
                    @if(auth()->user()->role == "Dispatch Manager")
                    <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalSmallreport" href="#">Report</a>
                    @else
                    <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModalSmallreport" href="#">Report</a>
                    @endif
                    <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#Advancesearch">
                         <i class="icon-search"></i>   Advance Search
                        </button>
                        <!-- Modal start -->
                        <div class="modal fade" id="Advancesearch" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalCenterTitle">Advance Search</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p><small>Advance search for Invoice Numbers, Customer Phone Number Or by Customer Outlet</small></p>
                                            <form action="/ceqa-dashboard/search-results-orders" method="get">
                                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                    <!-- Field wrapper start -->
                                                    <div class="field-wrapper">
                                                        <div class="input-group">														
                                                            <input type="text" class="form-control" name="search" placeholder="Search by Invoice No., customer Contact or Outlet">
                                                            <button class="btn btn-primary" type="submit">Search</button>
                                                        </div>
                                                        <div class="field-placeholder">Search</div>
                                                    </div>
                                                    <!-- Field wrapper end -->
                                                </div>
									        <!-- Row end -->
                                            </form>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Modal end -->
                    </div>
                </div>
                <div class="card-body">
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Outlet</th>
                            <th>Customer Contact</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dispatchorders as $order)
                        <tr>
                            <td>#{{$order->order_id}} <br>
                            Ordering Time: {{ \Carbon\Carbon::parse($order->created_at)->diffForHumans() }}
                            </td>
                            <td>{{$order->created_at}}</td>
                            <td>
                            {!! $order->dispatch_status == 0 ? '<span class="badge rounded-pill bg-danger">' . "Pending" . '</span>' : '<span class="badge rounded-pill bg-secondary">' . "Dispatching" . '</span>'!!}
                            </td>
                            <td>{{$order->branch}}</td>
                            <td><a href="tel:{{$order->customer_phone}}">{{$order->customer_phone}}</a></td>
                            <td>
                            <a href="#" class="btn btn-outline-primary rounded-pill mb-2" onclick="customer(this.id)" id="{{$order->customer_id}}"
                                data-bs-toggle="modal" data-bs-target="#exampleModalSmall">
                                <i class="icon-user1"></i>Customer
                            </a>
                             <!-- Modal start -->
                                <div class="modal fade" id="exampleModalSmall" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalSmallTitle">Customer Information</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div style="font-size:15px">
                                                <div id="name"></div>
                                                <div id="address"></div>
                                                <div id="phone"></div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Modal end -->
                            <a href="{{route('orderTransaction',$order->order_id)}}" class="btn btn-outline-info rounded-pill mb-2"><i class="icon-eye1" aria-hidden="true"></i> View Order</a>
                            @if(auth()->user()->role == "Call Center")
                            @else
                            @if($order->dispatch_status == 0)
                            <a href="#" class="btn btn-outline-success rounded-pill mb-2"  data-bs-toggle="modal" name="{{$order->total_cost_order}}" id="{{$order->order_id}} , {{$order->created_at}}" onclick="getOrderId(this.id)" data-bs-target="#staticBackdropDispatch">
                            <i class="icon-cycle"></i> Dispatch Order
                            </a>
                            @else
                            @endif
                            @endif
                            
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->
                    {{$dispatchorders->links()}}

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="staticBackdropDispatch" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Process Order</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form action="{{route('processOrder')}}" method="post">
                @csrf
                <input type="text" hidden readonly name="order_number"  readonly id="order_number">
                <div class="form-group">
                    <label for="">Rider Name</label>
                    <select name="rider_id" class="form-control">
                        <option selected disabled>Select Rider</option>
                        @foreach($riders_ as $rider)
                        <option value="{{$rider->id}}">{{$rider->rd_name}}</option>
                        @endforeach
                    </select>
                </div>


                <div class="form-group" style="margin-top:10px">
                    <label>Payment Option</label>
                    <select name="momo" required class="form-control">
                        <option selected value="CASH">CASH</option>
                        <option value="MOMO">MOMO</option>
                    </select>
                </div>

                <div class="form-group" style="margin-top:10px">
                    <label for="">Total Cost of Order</label>
                    <input name="amount" readonly required type="number" id="amount" step="0.01" class="form-control">
                </div>

                <div class="form-group" style="margin-top:10px">
                    <label for="">Delivery Price</label>
                    <input name="deliveryamount" required value="0" type="number" step="0.01" class="form-control">
                </div>

                <input name="customer_phone" hidden  required type="text" id="contact" class="form-control" value="">
                <input name="ordered_at" hidden required type="text" id="ordered_at" class="form-control" value="">


                <div style="margin-top: 12px;">
                    <button type="submit" required class="btn btn-success"> Process Now</button>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->
 

<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallreport" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">{{auth()->user()->role == "Call Center" ? "My Transactions": "Report On Dispatch"}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            @if(auth()->user()->role == "Call Center")
            <form action="{{route('dateReportByUser')}}" method="GET">
                        @csrf
                <div class="d-flex justify-content-end">
                    <!-- Field wrapper start -->
                    
                    <div class="field-wrapper m-0">
                        <div class="input-group">
                            <input type="text" name="user_id" id="user_id" hidden value="{{auth()->user()->id}}">
                            <input type="text" name="date" class="form-control custom-daterange2">
                            <span class="input-group-text">
                                <i class="icon-calendar1"></i>
                            </span>
                        </div>
                        <div class="field-placeholder">Select Date</div>
                    </div>
                    <!-- Field wrapper end -->
                    <button type="submit" class="btn btn-primary"><i class="icon-eye1" aria-hidden="true"></i></button>
                </div>
            </form>
            @else
           <form action="{{route('DispatchReport')}}" method="GET">
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="text" name="date" class="form-control custom-daterange">
                        <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                        </span>
                    </div>
                    <div class="field-placeholder">Select Date</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                <button class="btn btn-outline-primary btn-sm">
                    Report</button>
                </div>
           </form>
           @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal end -->
<script type="text/javascript">
   function customer(id) {
    const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // document.getElementById("demo").innerHTML = this.responseText;
                // console.log(this.responseText);
                // document.getElementById("myData").innerHTML = this.responseText;
                console.log(this.responseText)
                var data = JSON.parse(this.responseText);
                document.getElementById("name").innerHTML = "Name: " + data.customer_name;
                document.getElementById("address").innerHTML =  "Location: " + data.customer_address;
                document.getElementById("phone").innerHTML = "Phone: " +data.customer_phone;
                
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-info/"+ id);
            xhttp.send();
   }

   function markComplete(id) {
    Swal.fire({
        title: 'Are you sure?',
        text: "Do you really want to mark order as Completed!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, Complete it!'
        }).then((result) => {
        if (result.isConfirmed) {
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#highlightRowColumn").load(" #highlightRowColumn");
            }
            xhttp.open("GET", "/ceqa-dashboard/dispatch/"+ id);
            xhttp.send();

            Swal.fire(
            'Confirm!',
            'The Order is Marked Completed.',
            'success'
            )
        }
        })
   }

   function getOrderId(id) {
    var myarray = id.split(" , ");

    const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                var results = JSON.parse(this.responseText);
                document.getElementById("amount").value =  results.order_total_cost;
                document.getElementById("contact").value =  results.customer_phone;
                document.getElementById("order_number").value =  myarray[0];
                document.getElementById("ordered_at").value =  myarray[1];
                

            }
            xhttp.open("GET", "/ceqa-dashboard/order-infomation/"+ myarray[0]);
            xhttp.send();
   }


   function confirmReject() {
    const swalWithBootstrapButtons = Swal.mixin({
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                    buttonsStyling: false
                    })

                    swalWithBootstrapButtons.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!, contact Administrator for Assistance",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Mark Rejected!',
                    cancelButtonText: 'No, cancel!',
                    reverseButtons: true
                    }).then((result) => {
                    if (result.isConfirmed) {
                        swalWithBootstrapButtons.fire(
                        'Rejected!',
                        'the Order has been Rejected.',
                        'success'
                        )
                    } else if (
                        /* Read more about handling dismissals below */
                        result.dismiss === Swal.DismissReason.cancel
                    ) {
                        swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Process the Order if neccessary:)',
                        'error'
                        )
                    }
                    })
   }
</script>


@endsection