@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header-lg">
            <h5>Rider Dispatch Report</h5>
            <form action="{{route('RiderReportDate')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn btn-primary"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                </form>
            </div>  

                <div class="card-body">
                   
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Rider Name</th>	
                                  <th>Order Number</th>	
                                  <th>Dispatch Branch</th>											  
                                  <th>Motor Number</th>
                                  <th>Phone</th>	
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($riders_report as $report)
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{!!$report->rd_name!!}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$report->order_number}}
                                  </td>													  
                                  <td> {{$report->dispatch_branch}}</td>
                                  <td> {{$report->rd_motor}}</td>
                                  <td> {{$report->rd_phone}}</td>
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection