@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Task section start -->
            <div class="tasks-section">

                <!-- Labels container start -->
                <div class="labels-container">
                    <div class="lablesContainerScroll">
                        <div class="filters-block">
                            <h5>Filters</h5>
                            <div class="filters">
                                <a href="{{route('TransferOrderOutlet')}}" class="active">
                                    <i class="icon-receipt"></i> All
                                </a>
                                <a href="{{route('TransferOrderPending')}}">
                                    <i class="icon-error"></i> Pending Transfers
                                </a>
                                <a href="#">
                                    <i class="icon-check_circle"></i> Accepted Transfers
                                </a>
                                <a href="#">
                                    <i class="icon-cancel"></i> Rejected Transfers
                                </a>
                            </div>
                        </div>											
                    </div>
                </div>
                <!-- Labels container end -->

                <!-- Tasks container start -->
                <div class="tasks-container">
                    <div class="tasks-header">
                        <h3>Transfer Orders <span>{{$getDayClose->day_close}}</span></h3>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"> <i class="icon-shopping-cart1"></i> New Sale</button>
                    </div>
                    <div class="tasksContainerScroll">
                         <!-- Card start -->
                                <div class="table-responsive">
                                <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Outlet</th>
                            <th>Customer Contact</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($transactions as $order)
                        <tr>
                            <td><a href="{{route('orderTransaction',$order->order_id)}}">#{{$order->order_id}}</a>  
                            <p>Ordering Time: {{ \Carbon\Carbon::parse($order->created_at)->diffForHumans() }}</p>
                            </td>
                            <td>{{$order->created_at}}</td>
                            <td>
                            {!! $order->dispatch_status == 0 ? '<span class="badge rounded-pill bg-danger">' . "Pending" . '</span>' : '<span class="badge rounded-pill bg-secondary">' . "Dispatching" . '</span>'!!}
                            </td>
                            <td>{{$order->branch}}</td>
                            <td><a href="tel:{{$order->customer_phone}}">{{$order->customer_phone}}</a></td>
                            <td><a href="{{route('orderTransaction',$order->order_id)}}" class="btn btn-outline-info rounded-pill mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter{{$order->id}}"><i class="icon-directions" aria-hidden="true"></i>Transfer</a></td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                        </div>
                        <!-- Card end -->

                    </div>
                </div>
                <!-- Tasks container end -->

            </div>
            <!-- Task section end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@foreach($transactions as $order)
<!-- Modal start -->
<div class="modal fade" id="exampleModalCenter{{$order->id}}" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Order Number: {{$order->order_id}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('TransferOrderOutlet')}}" method="post">
                    @csrf
                <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <input type="text" name="order_number" value="{{$order->order_id}}" hidden>
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <input class="form-control" readonly type="text" value="{{$order->branch}}" name="transfer_from">
                                    <div class="field-placeholder">From <span class="text-danger">*</span></div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" title="Select Term" data-live-search="true" name="transfer_to">
                                        <option disabled selected>Select Outlet</option>
                                        @foreach($branch_list as $all_branch)
                                                <option>{{$all_branch}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Transfer to <span class="text-danger">*</span></div>

                                </div>
                                <!-- Field wrapper end -->

                            </div>
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <textarea class="form-control" rows="2" name="note"></textarea>
                                    <div class="field-placeholder">Note </div>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                        
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <button class="btn btn-primary">Transfer</button>
                            </div>
                        </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach
@endsection