@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Expense Report</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        @if(empty(request('branch')))
        <form action="{{route('ExpensesReportDate')}}" method="get">
            <div class="d-flex justify-content-end">
                 <!-- Field wrapper start -->
                 <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}" value="{{request('start_date')}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}" value="{{request('end_date')}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>
        @else

        <form action="{{route('ExpensesReportMain')}}" method="get">
        <input type="text" class="form-control" value="{{request('branch')}}" hidden name="branch">
            <div class="d-flex justify-content-end">
                 <!-- Field wrapper start -->
                 <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}" value="{{request('start_date')}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}" value="{{request('end_date')}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>


        @endif
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Card start -->
    <div class="card">
        <div class="card-header">
            <div class="card-title">Bills</div>
            @if(Route::currentRouteName() == "ExpensesReportMain")

            <form action="{{route('PrintExpensesMain')}}" method="GET">
                    <input type="text" class="form-control" value="{{request('branch')}}" hidden name="branch">
                    <input type="date" class="form-control" value="{{empty(request('start_date')) ? $dayClose->day_close : request('start_date')}}" hidden  name="start_date">
                    <input type="date" class="form-control" value="{{empty(request('end_date')) ? $dayClose->day_close : request('end_date')}}" hidden  name="end_date">
                            <button class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                    </form>

            @else
            <form action="{{route('PrintExpenses')}}" method="GET">
                    <input type="date" class="form-control" value="{{empty(request('start_date')) ? $dayClose->day_close : request('start_date')}}" hidden  name="start_date">
                    <input type="date" class="form-control" value="{{empty(request('end_date')) ? $dayClose->day_close : request('end_date')}}" hidden  name="end_date">
                            <button class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                    </form>
            @endif
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Expenses Type</th>
                        <th>Paid to</th>
                        <th>Amount Paid <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                        <th>Reference</th>
                        <th>Payment Account <br></th>
                        <th>Created at</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($expenses_today as $expenses_today)
                        <tr>
                            <td>{{@ucwords(@strtolower($expenses_today->e_type))}}
                                @if(!empty($expenses_today->e_document))
                                <p><a href="/uploads/{{$expenses_today->e_document}}" style="text-decoration:underline">Attchad Document</a></p>
                                 @endif
                            </td>
                            <td>{{$expenses_today->e_paid_to}}</td>
                            <td>@convert($expenses_today->e_amount)</td>
                            <td>{{@ucwords(@strtolower($expenses_today->e_reference))}}</td>
                            <td>{{@ucwords(@strtolower($expenses_today->payment_account))}}</td>
                            <td>{{$expenses_today->created_at}}</td>
                            <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-edit text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>
        </div>
    </div>
    <!-- Card end -->


                          

</div>
<!-- Content wrapper end -->


@endsection