@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Bill</li>
            </ol>
        </nav>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <div class="d-flex justify-content-end">
        @can('create', App\Models\User::class)
            <a href="#"  data-bs-toggle="modal" data-bs-target="#expensesType" class="btn btn-outline-info"> New Category</a>
        @endcan
            <a href="{{route('expenses.show')}}" class="btn btn-outline-primary"><i class="icon-download1"></i> Report</a>
        </div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->

<!-- Row start -->
<div class="row gutters">

    <div class="">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Bill</div>
            </div><br>
            <p style="margin-left: 2.5%"> Bill details appears in your Bill. Bill date is used in the dashboard and reports.</p>

            <div class="card-body mt-4">
                
                <form class="needs-validation" id="billing" method="POST" action="{{route('expenses.create')}}" enctype="multipart/form-data">
                @csrf  
                <!-- Row start -->
                    <div class="row gutters">
                    <div class="row gutters mb-3">
                        <div class="col-sm-5">
                          <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="e_name">
                                        @if(auth()->user()->role=="Administrator")
                                        <option disabled selected> - Select Station -</option>
                                        @foreach($warehouses as $warehouse)
                                        <option value="{{$warehouse->warehouse_name}}">{{@ucwords(@strtolower($warehouse->warehouse_name))}}</option>
                                        @endforeach
                                        @foreach($kitchens as $kitchen)
                                        <option value="{{$kitchen->kitchen_name}}">{{@ucwords(@strtolower($kitchen->kitchen_name))}}</option>
                                        @endforeach
                                        @else
                                             <option value="{{auth()->user()->station}}">{{@ucwords(@strtolower(auth()->user()->station))}}</option>
                                        @endif
                                </select>
                                
                                <div class="field-placeholder">Location <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                            <?php $vend = \DB::table('vendors')->pluck('vendor_name') ?>
                            <input class="form-control" name="e_paid_to" list="vendors" required>
                                <datalist id="vendors">
                                    @foreach($vend as $vendor)
                                        <option>{{@ucwords(@strtolower($vendor))}}</option>
                                        @endforeach
                                </datalist>
                                <div class="field-placeholder">Paid to</div>
                               
                            </div>
                        </div>
                    </div>

                    <div class="row gutters mb-3">
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                        <select class="select-single js-states" title="Select Product Category" name="e_type" data-live-search="true">
                                    <option disabled selected> - Select Type -</option>
                                    @foreach($expenses as $type)
                                    <option value="{{$type->account_number}}">{{@ucwords(@strtolower($type->account_name))}} ~ {{@ucwords(@strtolower($type->account_type))}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Expenses Type</div>
                            </div>
                        </div>
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                                <input type="text" class="form-control" name="e_reference" required>
                                <div class="field-placeholder">Expense Reference</div>
                            </div>
                        </div>
                    </div>

                    


                    <div class="row gutters mb-3">

                        <div class="col-sm-5">
												
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" title="Select Product Category" name="expenses_category" data-live-search="true">
                                <option disabled selected> - Select Category -</option>
                                @foreach($expense_category as $category)
                                <option> {{@ucwords(@strtolower($category->expense_type_name))}}</option>
                                @endforeach
                                </select>
                                <div class="field-placeholder">Expenses Category</div>
                            </div>
                            <!-- Field wrapper end -->
    
                        </div>

                        <div class="col-sm-5">
                        <div class="field-wrapper">
                                <input type="number" min="0" step="0.0001" class="form-control" name="e_amount" required>
                                <div class="field-placeholder">Amount</div>
                               
                            </div>
                        </div>
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                            <select class="select-single js-states" title="Select Product Category" name="e_payment" data-live-search="true">
                            <option value="CASH">Cash ~ ({{empty($app->currency) ? "GHS" : $app->currency}})</option>
                                @foreach($payment_methods as $payment_name)
                                     <option value="{{$payment_name}}">{{@ucwords(@strtolower($payment_name))}} ~ ({{@ucwords(@strtolower(empty($app->currency) ? "GHS" : $app->currency))}})</option>
                                @endforeach
                            </select>
                            <div class="field-placeholder">Payment Method</div>
                                
                        </div>
                        </div>
                    </div>


                    <div class="row gutters mb-3">
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                            <input type="date" class="form-control" name="e_date" max="{{$dayClose->day_close}}" value="{{$dayClose->day_close}}" required>
                            <div class="field-placeholder">Paid on</div>
                         </div>
                        </div>
                        <div class="col-sm-5">
                        <div class="field-wrapper">
                                <input type="file" class="form-control" name="image">
                                <div class="field-placeholder">Attach Document</div>
                            </div>
                        </div>
                    </div>


                    <div class="row gutters mb-3">
                        <div class="col-sm-8">
                        <div class="field-wrapper">
                            <textarea name="e_note" id="" cols="30" rows="10"></textarea>
                            <div class="field-placeholder">Expense Note</div>
                         </div>
                        </div>
                        <!-- <div class="col-sm-2">
                        <div class="field-wrapper">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="checkbox"  value="e_refund">
                            <label class="form-check-label" for="chcekEmail">Is Refund?</label>
                        </div>
                        </div>
                        </div> -->
                    </div>

                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
												
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <select class="select-single js-states" title="Select Product Category" name="payment_account" data-live-search="true">
                                @foreach($payment_accounts as $payment_accounts)
                                    <option value="{{$payment_accounts -> account_number}}">{{@ucwords(@strtolower($payment_accounts->account_name))}} ~ {{@ucwords(@strtolower($payment_accounts->account_type))}}</option>
                                @endforeach
                            </select>
                            <div class="field-placeholder">Payment Account</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                        
                        <div class="col-12">
                            <button class="btn btn-primary" type="button" onclick="bill()">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


@include('modal.expenses-type')


  <script>
    function bill() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are creating a new bill, you may not be able to revert",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, save!'
            }).then((result) => {
            if (result.isConfirmed) {
                $('#loading-wrapper').show();
                document.getElementById("billing").submit();
            }
            })
    }
</script> 

@endsection