@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item active" aria-current="page">Goods Receipts Note</li>
            </ol>
        </nav>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <div class="d-flex justify-content-end">
            <form action="{{route('GRNListDate')}}" method="GET">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <select class="select-single js-states" title="Select Term" data-live-search="true" name="vendor">
                        <option value="All Vendors" selected>{{request()->vendor == null ? "All Vendors" : request()->vendor}}</option>
                        @foreach($vendors as $vendor)
                        <option value="{{$vendor->vendor_name}}">{{@ucwords(@strtolower($vendor->vendor_name))}}</option>
                        @endforeach
                    </select>
                        <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info">Report</button>
                    </div>
                </div>
                <!-- End field Wrapper -->
            </form>
            
        </div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
             <!-- Card start -->
             <div class="card">
                <div class="card-header">
                    <div class="card-title">Goods Receipts</div>
                    
                    <form action="{{route('GRNListDatePrint')}}" method="GET">
                        <input type="text" hidden name="vendor" value="{{empty(request('vendor')) ? "All Vendors" : request('vendor')}}">
                      <input hidden type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>">
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                        </form>
                    
                </div>
                
                <div style="margin-left:20px;">
                    Report for:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Station: <?=auth()->user()->station?>
                </div>


                <div style="margin:12px">
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Trans. Code</th>
                              <th>Date</th>													  
                              <th>Vendor</th>	
                              <th>Bill Amount <br>{{empty($app->currency) ? "GHS" : $app->currency}} </th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                              <td>{{$list->transaction}}</td>
                              <td>{{$list->date}}</td>													  
                              <td>{{@ucwords(@strtolower($list->vendor))}}</td>
                              <td>@convert(round($list->total_amount, 2))</td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('goods.show',$list->transaction)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                            
                        </tbody>
                </table>
                </div>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection