@extends('layouts.fullscreen')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Vendor Transactions</h4>

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

                <form action="{{route('StockFilterPrint')}}" id="print-stock" method="get">
                    <input type="text" name="item_id" value="{{request('item_id')}}" hidden>
                    <input type="date" class="form-control" value="{{empty(request('start_date')) ? $dayClose->day_close   :  request('start_date')}}" hidden name="start_date">
                    <input type="date" class="form-control" value="{{empty(request('end_date')) ? $dayClose->day_close   :  request('end_date')}}" hidden name="end_date">
                </form>
                
                    

                     <form action="{{route('GRNListDateFiler')}}" method="get">

                     <input type="text" name="vendor" value="{{$vendor->vendor_name}}" hidden>
                        <div class="d-flex justify-content-end">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper m-0">
                                <div class="input-group">
                                <button class="btn btn-outline-info" style="margin-right:10px" type="button" onclick="PrintAccount()"><i class="icon-printer"></i>Print</button>
                                <div style="margin-right:10px"><small>From</small></div>
                                <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}">
                                <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                                <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}">
                                    <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                    </span>
                                    <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                                </div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                    </form>
                </div>

            </div>
            <div class="card-body">

                <div class="invoice-container">


                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                <div class="table-responsive">
											<table class="table table-sm">
												<tbody>
													<tr>
														<td><strong style="font-weight:600">Vendor Name</strong></td>
														<td>{{@ucwords(@strtolower($vendor->vendor_name))}}</td>
													</tr>
													<tr>
														<td><strong style="font-weight:600">Contact</strong></td>
														<td>{{$vendor->vendor_phone}}</td>
													</tr>
                                                    <tr>
														<td><strong style="font-weight:600">Email</strong></td>
														<td>{{@ucwords(@strtolower($vendor->vendor_emai))}}</td>
													</tr>
													
													
												</tbody>
											</table>
                                        </div>
                                    </address>

                                <div class="invoice-num">
                                    <div>{{$to . "/" . $from}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Date</th>
                                            <th>Item</th>
                                            <th>Type</th>
                                            <th>Receipt</th>
                                            <th>Issue</th>
                                            <th>Rate <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                            <th>Item Value <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    @if($balance_b_f_ !== 0)
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td>Balance B/F</td>
                                            <td></td>
                                            <td></td>
                                           <td></td>
                                           <td></td>
                                        </tr>
                                        @endif
                                       
                                        @foreach($transactions_db->chunk(50) as $rows)
                                        @foreach($rows as $transactions)
                                        @if(empty($transactions->receipt) && empty($transactions->issue))
                                            @continue
                                        @endif
                                        <tr>
                                        <td>{{$transactions->id}}</td> 
                                            <td>
                                            <?php 
                                                $date = \Carbon\Carbon::parse($transactions->created_at, 'UTC');
                                            ?>
                                                {!!$date->isoFormat('Do MMM YYYY, h:mm:ss a')!!}

                                            </td>
                                           
                                            <td>
                                                <?php $items = \DB::table('items')->where('id', $transactions->item_id)->first(); ?>

                                                <form method="get" action="{{route('StockFilter')}}" id="form-id<?= $items->id?>">
                                                    <input type="text" name="item_id" value="{{$items->id}}" hidden>
                                                    <input type="date" class="form-control" name="start_date" hidden value="{{$from}}" max="{{$dayClose->day_close}}">
                                                    <input type="date" class="form-control" name="end_date" hidden value="{{$to}}" max="{{$dayClose->day_close}}">
                                                </form>
                                                <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$items->id?>').submit();">
                                                
                                                {{@ucwords(@strtolower($items->item_name))}}

                                                </a>
                                        
                                            </td>

                                            <td>{!!@ucwords(@strtolower($transactions->description))!!}
                                                <p class="text-mute">{!! $transactions->note !!}</p>
                                            </td>
                                           
                                            <td>
                                            @if(!empty($transactions->receipt) || null)
                                                @convert($transactions->receipt)
                                            @endif
                                            </td>
                                            <td>
                                                @if(!empty($transactions->issue) || null)
                                                @convert($transactions->issue)
                                                @endif
                                            </td>
                                           
                                            <td>@convert($transactions->cost)</td>
                                            <td>
                                            @if(!empty($transactions->issue) || null)
                                                 @convert($transactions->cost * $transactions->issue)
                                            @else
                                                @convert(-1 * ($transactions->cost * $transactions->receipt))
                                            @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            
                        </div>
                    </div>
                   
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
						<!-- Row end -->


</div>

<script>
    function DeleteAccount(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are removing this transaction, you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Remove !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/account/transaction/delete/" + id;
            }
            })
    }


    function PrintAccount() {
        document.getElementById("print-stock").submit();
    }
</script>


@endsection