@extends('layouts.app')

@section('content')
<?php  $goods_state = \App\Models\GoodReceiptList::where('transaction_id', $trans_data->g_r_transaction_id)->first()?>


<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header-lg">
                    <h4>Goods Receipts Note
                    @if($goods_state->return_state == 1)
                    <div class="spinner-grow spinner-grow-sm text-danger" role="status">
                            <span class="badge bg-danger">
                            Returned Goods</span>
                        </div>
                        @endif
                    </h4>
                    <div class="text-end">
                        <a href="{{route('warehousedocks.index')}}" class="btn btn-outline-primary">New GRN</a>
                    </div>
                </div>
                <div class="card-body">

                    <div class="invoice-container">


                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="invoice-details">
                                    <address class="m-0">
                                    <strong>{{$vendor->vendor_name}}</strong><br>
                                        {{$vendor->vendor_email}}<br>
                                        {{$vendor->vendor_phone}}<br>
                                        {{$vendor->vendor_address}}
                                    </address>

                                    <div class="invoice-num">
                                        <div>Trans. ID - #{{$trans_data->g_r_transaction_id}}</div>
                                        <div>{{$trans_data->g_r_date}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-12">
                                
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Item Name</th>
                                                <th>UOM</th>
                                                <th>Qty</th>
                                                <th>Rate <br>{{empty($app->currency) ? "GHS" : $app->currency}}</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $sumTotalGoods = 0 ;?>

                                            @foreach($reciept_goods as $goods)

                                            <?php 
                                            
                                            $sumTotalGoods += round((round($goods->g_r_rate,2) * round($goods->g_r_quantity, 2)), 2);
                                            $total = round($sumTotalGoods, 2);
                                            
                                            ?>

                                            <tr>
                                                <td>{{$loop->iteration}} </td>
                                                <td>{{@ucwords(@strtolower($goods->g_r_item))}}</td>
                                                <td>{{$goods->g_r_unit}}</td>
                                                <td>{{$qty = round($goods->g_r_quantity, 2)}}</td>
                                                <td>{{$rate = round($goods->g_r_rate, 2)}}</td>
                                                <td>@convert(round($rate * $qty,2))</td>
                                            </tr>
                                            
                                            @endforeach
                                            <tr>
                                                
                                                <td colspan="4">&nbsp;</td>
                                                <td>
                                                    <p class="m-0">Subtotal</p>
                                                    <p class="m-0">Discount</p>
                                                    <p class="m-0">VAT</p>
                                                    <h5 class="mt-2 text-danger">Total</h5>
                                                </td>
                                                <td>
                                                    <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($total, 2))</p>
                                                    <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}00.00</p>
                                                    <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}00.00</p>
                                                    <h5 class="mt-2 text-danger">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($total, 2))</h5>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <p>{{@ucwords(@strtolower($goods_state->note))}}</p>
                                <?php $users = \App\Models\User::find($goods_state->user_id); ?>
                                <p>Added By: {{$users->name}}</p>
                                
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="text-start">
                                    <a class="btn btn-outline-primary" href="{{route('downloadPrint', $trans_data->g_r_transaction_id)}}"> <i class="icon-printer"></i> Print</a>

                                    @if($goods_state->return_state == 0)
                                    <div style="float:right">
                                        <a class="btn btn-outline-light" href="#" id="{{$trans_data->g_r_transaction_id}}" onclick="ReturnGoods(this.id)"><i class="icon-swap"></i> Return Goods</a>
                                    </div>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <!-- Row end -->
                    
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
    function ReturnGoods(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are returning goods, you may not be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Return !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/return-goods/" + id;
            }
            })
    }
</script>

@endsection