@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="container">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Held transactions </h3>
                    <a href="{{route('HeldTransactionComplete')}}" class="btn btn-outline-primary"><i class="icon-bookmark1"></i> Completed transactions</a>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                            <th>EnteredBy</th>
                            <th>Outlet</th>
                                <th>OrderID.</th>
                                <th>CreatedAt </th>
                                <th>Customer</th>
                                <th>Discount</th>
                                <th>Total</th>
                                @if(auth()->user()->role !== "Sales Person")
                                <th>Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($heldTransaction as $list)
                            <tr>
                                <td>{{$list->user->name}}</td>
                                <td>{{$list->branch}}</td>
                                <td># <a href="{{route('orderTransaction',$list->order_id)}}">{{$list->order_id}}</a></td>
                                <td>{{$list->created_at}}</td>
                                <td><a href="{{route('orders.customer', encrypt($list->customer->id))}}">{{$list->customer->customer_name}}</a></td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->discount)</td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->total_cost_order)</td>
                                <td>
                                    <!-- <button class="btn btn-poutline-light" data-bs-toggle="modal" data-bs-target="#exampleModalchangestatus{{$list->id}}">
                                    <i class="icon-check"></i> confirm Payment
                                    </button> -->
                                    <a href="{{route('orderTransaction',$list->order_id)}}" class="btn btn-success">SHOW ITEMS</a> 
                                </td>
                            </tr>
                            @endforeach
                        </tbody> 
                    </table>
                    </div>
                    <!-- Row end -->
                    </div>
                </div>
            </div>
            <!-- Card end -->

        </div>


        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->




<script>
    function getOrderId(id) {
        document.getElementById('id').value = id
    }


    $("#change").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('changeInvoiceStatus')}}",
                dataType: "json",
                data: $('#change').serialize(),
                success: function(data){
                    var item_id = JSON.parse(data.item_id);
                    var status = JSON.parse(data.status);
                    var invoice_id = JSON.parse(data.invoice_id);
                   
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Status Changed Successfully'
                    })
                
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>


@endsection