<form class="row gutters" action="{{route('ChangeProduct', $item_details->id)}}" method="post">
    @csrf
<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <input type="text" class="form-control" name="p_name" value="{{$item_details->item_name}}">
            <div class="field-placeholder">Name</div>
        </div>
        <!-- Field wrapper end -->
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <select  name="p_category" class="select-single js-states" title="Select Product Category" data-live-search="true">
                <option selected>{{$item_details->item_category}}</option>
                @foreach($categories as $category)
                <option>{{$category->category_name}}</option>
                @endforeach
            </select>
            <div class="field-placeholder">Category</div>
        </div>
        <!-- Field wrapper end -->
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
            <select class="select-single js-states" title="Select Term" data-live-search="true" name="item_unit">
                <option selected>{{$item_details->item_unit}}</option>
                @foreach($units as $unit)
                <option>{{$unit->abbreviation}}</option>
                @endforeach
            </select>
            </div>
            <div class="field-placeholder">UOM</div>
        </div>
        <!-- Field wrapper end -->
    </div>

    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Field wrapper start -->
            <div class="field-wrapper m-0">
                <textarea class="form-control" name="p_description" rows="3">{{$item_details->item_description}}</textarea>
                <div class="field-placeholder">Description</div>
        </div>
            <!-- Field wrapper end -->
    </div>


    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input type="text" class="form-control" name="product_code"
                value="{{$item_details->item_code}}"
                >
                <span class="input-group-text">
                </span>
            </div>
            <div class="field-placeholder">Item code</div>
        </div>
        <!-- Field wrapper end -->
    </div>

    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
    <div class="field-wrapper">
        <select name="stations[]" class="select-multiple js-states" title="Select Product Category" multiple="multiple">
        @if(!empty($item_details->inactive_station))
        @foreach(json_decode($item_details->inactive_station) as $branch)
        <option selected>{{$branch}}</option>
        @endforeach
        @endif
        @foreach($warehouses as $warehouse)
        <option value="{{$warehouse->warehouse_name}}">{{@ucwords(@strtolower($warehouse->warehouse_name))}}</option>
        @endforeach
        @foreach($kitchens as $kitchen)
        <option value="{{$kitchen->kitchen_name}}">{{@ucwords(@strtolower($kitchen->kitchen_name))}}</option>
        @endforeach
        </select>
        <div class="field-placeholder">Outlet</div>
        <small class="text-info">Make stock inactive at selected outlets</small>
    </div>
    </div>


    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12" style="margin-top:9px">
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="checkbox" id="checkSms2" value="1" <?= $item_details->item_manufacturing == 1 ? 'checked' : ''  ?> name="item_manufacturing">
            <label class="form-check-label" for="checkSms2">Manufacturing</label>
        </div>
        <div class="form-check form-check-inline">
            <input class="form-check-input" type="checkbox" id="checkSms2" value="1" name="transfer_status" <?= $item_details->transfer_status == 1 ? 'checked' : ''  ?>>
            <label class="form-check-label" for="checkSms2">Transferable</label>
        </div>
    </div>

    
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <div class="modal-footer">
        
        <button type="submit" class="btn btn-outline-primary">Make Changes</button>

        <button type="button" class="btn btn-outline-danger" id="{{$item_details->id}}" onclick="DeleteItem(this.id)"><i class="icon-trash"></i> Delete Item</button>
    </div>
</form>
</div>



<script>
    function DeleteItem(data) {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are deleting a stock , You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Remove!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/remove-item-from-store/"+ data;
            }
            })
    }
</script>