@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="/">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Adjust Purchase Rate</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('AdCost')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="date" class="form-control" name="date">
                    <button class="btn btn-info">Adjust</button>
                       
                    </div>
                    
                </div>
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Stock & Cost</div>
                                    </div>
                                    
									<div class="card-body">
                                    <form action="{{route('save.adjustprice')}}" id="adjustStockSb" method="POST">

                                        @csrf
                                    <div class="table-responsive">
                                    <table id="basicExample" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Item</th>
                                                    <th>Unit</th>
                                                    <th>Category</th>
                                                    <th>Current Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th> 
                                                    <th>New Rate</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($rate as $rate)
                                                    <tr>
                                                        <td>{{$rate->item_name}}</td>
                                                        <td>{{$rate->item_unit}}</td>
                                                        <td>{{$rate->item_category}}</td>
                                                        <td>
                                                            <?php $last_cost = \DB::table('average_costs')->where('item_id', $rate->id)->orderBy('id', "DESC")->first();

                                                                if(empty($last_cost)){
                                                                    $last_cost = 0;
                                                                }else {
                                                                    $last_cost = $last_cost->weighted_average;
                                                                }
                                                            ?>
                                                                @convert($last_cost)
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control" name="items[<?=$rate->id;?>][rate_amount]" value="@convert($last_cost)" placeholder="Enter Rate" >
                                                            <input type="text" class="form-control" name="items[<?=$rate->id;?>][item_id]" value="{{$rate->id}}" hidden>
                                                        </td>
                                                        
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>
                                       <div style="margin-top:12px">
                                         <button class="btn btn-primary" type="button" onclick="physical()">Save</button>
                                       </div>
                                        </form>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->





                    <script>
                        function physical() {
                            Swal.fire({
                                title: 'Are you sure?',
                                text: "cost of stock will be updated, you may not be able to revert this!",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                confirmButtonText: 'Yes, save!'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    document.getElementById("adjustStockSb").submit();
                                }
                                })
                                
                        }
                        
                    </script> 
@endsection