@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Closing Stocks</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('ClosingStockDate')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <!-- Field wrapper end -->
                <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Stocks -  [Closing Stock]</div>

                    @if(request()->branch == null)
                    <form action="{{route('closingStocksPrint')}}" method="GET">
                            <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                        </form>
                    @else
                    <form action="{{route('PrintSalesAnalysisBranch')}}" method="GET" >
                    <input type="text" name="branch" value="{{request()->branch}}" hidden>  
                    <input type="text" name="type" value="{{request()->type}}" hidden>        
                    <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                        </form>
                    @endif
                </div>
                
                <div style="margin-left:20px;">
                    Date:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Station: <?=auth()->user()->station?>
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Item name</th>
                                <th>UOM</th>
                                <th>Closing Stock</th>
                                <th>Rates <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                <th>Item Value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($closing_stocks as $report)
                                <tr>
                                    <td>{{$loop->iteration}}</td>
                                    <td>{{@ucwords(@strtolower($report->item_name))}}</td>
                                    <td>{{@ucwords(@strtolower($report->item_unit))}}</td>
                                    <td>@convert($report->item_closing_stock)</td>
                                    <td>@convert($report->item_cost)</td>
                                    <td>@convert($report->item_cost * $report->item_closing_stock)</td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection