@extends('layouts.app')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="index.html">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Stock Limits</li>
                    </ol>
                </nav>
            </div>
        <!-- <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
            <form action="{{route('trashSort')}}" method="get">
            <div class="d-flex justify-content-end">
                
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <button class="btn btn-danger">Advance Report Option</button>
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
            </div>
            </form>
        </div> -->
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->

						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">New Stock Limit</div>
                                    </div>
                                    
                                    <div style="margin-left:20px; margin-top:12px">
                                        Create New Stock, Station: <?=auth()->user()->station?>
                                        <div>
                                            <small class="text-danger">Notify user When Item is Out of Stock</small>
                                        </div>
                                    </div>
                                    
									<div class="card-body">
                                    <form action="{{route('saveStockLimt')}}" id="stocktaking" method="POST">
                                        @csrf
                                    <div class="table-responsive table-sm">
                                    <table id="basicExample" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Items</th>
                                                    <th>Item Category</th>
                                                    <th>UOM</th>
                                                    <th>Stock Limit</th>
                                                    @if(auth()->user()->role == "Administrator")
                                                    <th>Enable stock checker</th>
                                                    @endif
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($stock_limit as $report)
                                                    <tr>
                                                        <td>{{$report->item_name}}</td>
                                                        <td>{{$report->item_category}}</td>
                                                        <td>{{$report->item_unit}}</td>
                                                        <td>
                                                           
                                                            <input type="number" min="0" step="0.01" placeholder="Enter Re-order Level"  class="form-control" name="items[<?=$report->id;?>][issue_item_stock_limit]" value="{{empty($report->order_level) ? Null : $report->order_level}}">
                                                            <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_item_id]" value="{{$report->id}}" hidden>
                                                            
                                                        </td>
                                                        @if(auth()->user()->role ==  "Administrator")
                                                        <td>
                                                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
												
                                                            <!-- Field wrapper start -->
                                                            <div class="field-wrapper">
                                                                <select class="select-single js-states" name="items[<?=$report->id;?>][item_stock_check]" title="Select Product Category" data-live-search="true">
                                                                    <option value="{{$report->item_stock_check}}" selected>
                                                                        {{$report->item_stock_check ==  1 ? "Yes" : "No"}}
                                                                    </option>
                                                                    <option value="0">No</option>
                                                                    <option value="1">Yes</option>
                                                                </select>
                                                                <div class="field-placeholder">state</div>
                                                            </div>
                                                            <!-- Field wrapper end -->

                                                        </div>
                                                        </td>
                                                        @endif
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>

                                        <div style="margin-top:12px">
                                           <button class="btn btn-primary" type="button" onclick="physical()">Create</button>
                                        </div>

                                        </form>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->




                    <script>
                        function physical() {
                            Swal.fire({
                                title: 'Are you sure?',
                                text: "you are submitting re-order levels and checking for stock at sells point. you may not be able to revert",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                confirmButtonText: 'Yes, Save!'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    document.getElementById("stocktaking").submit();
                                }
                                })
                        }
                    </script>


@endsection