@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="/">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Issue Register</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('issueRegisterDate')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <a href="{{route('StoreWiseIssueRegister')}}" class="btn btn-outline-secondary">Detailed Report</a>
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Issue Register - [Issue Item Summary]</div>

                                        <form action="{{route('IssueRegisterPrint')}}" method="GET">
                                                <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                                        </form>
                                       

                                    </div>
                                    
                                    <div style="margin-left:20px; margin-top:2px">
                                        Date:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Issue Station: <?=auth()->user()->station?>
                                    </div>
                                    
									<div class="card-body">
                                    <div class="table-responsive">
                                            <table id="copy-print-csv" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Items</th>
                                                    <th>UOM</th>
                                                    <th>Quantity</th>
                                                    <th>Recieving Store</th>
                                                    <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}} </strong></th>
                                                    <th>Item Value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}} </strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($inventory as $report)
                                                    <tr>
                                                        <td>{{$report->name}}</td>
                                                        <td>{{$report->unit}}</td>
                                                        <td>{{$report->quantity}}</td>
                                                        <td>{{$report->issue_store}}</td>
                                                        <td>{{ $rate = round($report->rate, 2)}}</td>
                                                        <td>{{round($rate * $report->quantity, 2)}}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->


@endsection