@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
<nav aria-label="breadcrumb">
<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.html">Home</a></li>
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
    <li class="breadcrumb-item active" aria-current="page">Issue Register - StoreWise</li>
</ol>
</nav>
</div>
<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
<!-- Top Actions - DateRange and Buttons -->
<form action="{{route('storewiseDate')}}" method="get">
<div class="d-flex justify-content-end">
<!-- Field wrapper start -->
<div class="field-wrapper m-0">
<div class="input-group">
<!-- <a href="{{route('StoreWiseIssueRegister')}}" class="btn btn-danger">Advanced Details</a> -->
<input type="text" class="form-control custom-daterange2" name="date">
    <span class="input-group-text">
    <i class="icon-calendar1"></i>
    </span>
</div>
</div>
<!-- Field wrapper end -->
<button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
</div>
</form>
</div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Issue Register - [Issue Item Summary - Store Wise]</div>
                    
                </div>
                
                <div style="margin-left:20px; margin-top:12px">
                    Date:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Issue Station: <?=auth()->user()->station?>
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                <table class="table table-bordered m-0">
                            <thead>
                                <tr>
                                    <th colspan="2">STATIONS</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($report as $station => $report)
                                <tr>
                                    <td><strong>{{$station}}</strong></td>
                                    <td>
                                    <div class="table-container light-blue">
									<table class="table v-middle m-0">
                                        <thead>
                                            <tr>
                                                <th>Item name</th>
                                                <th>Recieving station</th>
                                                <th>UOM</th>
                                                <th>Date</th>
                                                <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                                <th>Quantity</th>
                                                <th>Item Value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                            </tr>
                                        </thead>
                                        @foreach($report as $item)
                                        <tr>
                                            <td>{{@ucwords(@strtolower($item->name))}}</td>
                                            <td>{{$item->issue_store}}</td>
                                            <td>{{$item->unit}}</td>
                                            <td>{{$item->issue_date}}</td>
                                            <td>@convert($item->rate)</td>
                                            <td>{{$item->quantity}}</td>
                                            <td>@convert($item->rate*$item->quantity)</td>                                                            </tr>
                                        @endforeach
                                        <?php
                                            $sumItem = 0;
                                            $sumQty = 0;
                                            foreach ($report as $item) {
                                                $sumItem += $item->rate*$item->quantity;
                                                $sumQty += $item->quantity;
                                            }

                                        
                                        ?>
                                        <tr>
                                            <td><span class="text-primary"><strong>Grand Total</strong></span></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td class="text-primary">@convert($sumQty)</td>
                                            <td></td>
                                            <td class="text-primary">@convert($sumItem)</td>
                                        </tr>
                                         </table>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection