@extends('layouts.fullscreen')

@section('content')

<style>
      @media print {
      body * {
        visibility: hidden;
      }
      
      #pbuton{
        visibility: hidden;
      }
      #section-to-print, #section-to-print * {
        visibility: visible;
      }
      #section-to-print {
        position: absolute;
        left: 0;
        top: 0;
      }
    }
</style>
<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Issue Item Summary -  Item wise</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('storewiseDate')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <a href="#" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#exampleModalAd">Item Issue</a>

                    <!-- Date -->
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <!-- Field wrapper end -->
                <button class="btn btn-info"><i class="icon-download1"></i> Reports</button>
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card" id="section-to-print">
                <div class="card-header">
                    <div class="card-title">Issue Register - All Issue register</div>
                            <button class="btn btn-outline-primary" onclick="display()" id="pbuton"> <i class="icon-print"></i> Print</button>
                </div>
                
                <div style="margin-left:20px;">
                    Date: {{request()->date == null ? $dayClose->day_close : request()->date }}
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                <table class="table table-bordered m-0">
                            <thead>
                                <tr>
                                    <th colspan="2">STATIONS</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($report as $station => $report)
                                <tr>
                                    <td><strong>{{$station}}</strong></td>
                                    <td>
                                    <div class="table-container light-blue">
									<table class="table v-middle m-0">
                                        <thead>
                                            <tr>
                                                <th>Item name</th>
                                                <th>UOM</th>
                                                <th>Voucher No.</th>
                                                <th>Recieving station</th>
                                                <th>Date</th>
                                                <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                                <th>Quantity</th>
                                                <th>Store unit qty</th>
                                                <th>Item Value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                            </tr>
                                        </thead>
                                        @foreach($report as $item)
                                        <tr>
                                            <td>{{@ucwords(@strtolower($item->issue_item))}} </td>
                                            <td>{{$item->issue_unit}}</td>
                                            <td>#{{$item->issue_transaction_id}}</td>
                                            <td>{{$item->issue_store}}</td>
                                            <td>{{$item->issue_date}}</td>
                                            <td>{{round($item->issue_rate,2}}</td>
                                            <td>@convert($item->issue_quantity)</td>
                                            <td>@convert($item->issue_quantity)</td>
                                            <td>{{round($item->issue_rate*$item->issue_quantity,2}}</td>  
                                         </tr>
                                        @endforeach
                                        <?php
                                            $sumItem = 0;
                                            $sumQty = 0;
                                            foreach ($report as $item) {
                                                $sumItem += $item->issue_rate*$item->issue_quantity;
                                                $sumQty += $item->issue_quantity;
                                            }

                                        
                                        ?>
                                        <tr>
                                            <td><span class="text-primary"><strong>Grand Total</strong></span></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td class="text-primary">@convert($sumQty)</td>
                                            <td></td>
                                            <td class="text-primary">@convert($sumItem)</td>
                                        </tr>
                                    </table>
                                    </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="exampleModalAd" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Issue Register - Item wise</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <?php $item_le = \DB::table('items')->get() ?>
        <form action="{{route('IssueRegisterStoreWise')}}" method="get">
                @csrf
            <!-- Field wrapper start -->
            <div class="field-wrapper">
                <select class="select-single js-states" title="Select Term" data-live-search="true" name="item">
                    @foreach($item_le as $item)
                    <option value="{{$item->id}}">{{$item->item_name}}</option>
                    @endforeach
                </select>
                
                <div class="field-placeholder">Item Name<span class="text-danger">*</span></div>
            </div>
            <!-- Field wrapper end -->


            <!-- Field wrapper start -->
            <div class="field-wrapper">
                <div class="input-group">
                <input type="text" class="form-control custom-daterange2" name="date">
                    <button class="btn btn-primary">Submit</button>
                </div>
                <div class="field-placeholder">Datepicker</div>
            </div>
            <!-- Field wrapper end -->
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script>
    function display() {
          window.print();
         }
</script>


@endsection