<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>ISL With Stock Balances  {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">


		
	</head>

<body onload="window.print();">


<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="#" class="logo">
                <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-width:120px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong>{{$app->app_name}}</strong>,<br>
                    <?= @strtoupper("Item Stock Ledger -  [Stock balance]") ?><br>
                    REPORT FOR: <?=@strtoupper(auth()->user()->station);?>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
    @if($reporting->isEmpty())
                    <?php 
                    
                    $last_stock = \DB::table('item_stock_ledgers')->where('date', $dayClose->day_close)->where('station', auth()->user()->station)->get();

                    $sumRates = 0;
                    $sumRatesTotal = 0;
                    foreach ($last_stock as $key => $report) {
                        $rates = $report->item_cost;
                        $rates_ = $report->item_cost * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing));
                        $sumRates += $rates;
                        $sumRatesTotal += $rates_ ;
                    }
                    
                    ?>
                    <div class="table-responsive">
                    <table class="table table-bordered table-striped m-0">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>UOM</th>
                                <th>Opening Stock</th>
                                <th>Stock In</th>
                                <th>Stock Out</th>
                                <th>Closing Stock</th>
                                <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                <th>Item value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($last_stock as $report)

                                <tr>
                                    <td>
                                    <?php $date = $dayClose->day_close;
                                        $date1 = new \DateTime($date);
                                        $dayclose = $date1->format('m/d/Y');
                                    ?>
                                    <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                        <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                        <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                        <input type="text" name="opening" value="{{$report->item_opening_stock}}" hidden>
                                        <input type="text" name="closing" value="{{$report->item_closing_stock}}" hidden>
                                        <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                    </form>
                                    <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{$report->item_name}}</a></td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>
                                    <?php 
                                            $opening = \DB::table('item_stock_ledgers')
                                            ->whereDate('date', $dayClose->day_close)
                                            ->where('item_id', $report->item_id)
                                            ->where('station', auth()->user()->station)
                                            ->first();
                                        ?>
                                        @convert($opening->item_opening_stock)
                                    </td>
                                    <td>@convert(0)</td>
                                    <td>@convert(0)</td>
                                    <td>@convert($closting_stock = (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))</td>
                                    <td>
                                         @convert($report->item_cost)
                                    </td>
                                    <td>
                                        @convert($report->item_cost * $closting_stock)
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong>Total</strong></td>
                                    <td> <strong> @convert($sumRates)</strong></td>
                                    <td> <strong>
                                        
                                    @convert($sumRatesTotal)

                                    </strong></td>
                                </tr>
                    </table>
                    </div>
                    @else
	<table class="table table-bordered table-striped m-0">
    <thead>
                                <tr>
                                <th>Item name</th>
                                <th>UOM</th>
                                <th>Opening Stock</th>
                                <th>Receipts</th>
                                <th>Issues</th>
                                <th>Closing Stock</th>
                                <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                <th>Item value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                </tr>
                        </thead>
                            <tbody>

                            <?php $sum = 0;
                            $sumCash = 0; 
                                foreach ($reporting as $report) {

                                    $closing = \DB::table('item_stock_ledgers')
                                        ->whereDate('date', $dayClose->day_close)
                                        ->where('item_id', $report->item_id)
                                        ->where('station', auth()->user()->station)
                                        ->first();

                                    $result = empty($report->item_cost) ? (empty($closing->item_cost) ? 0 : $closing->item_cost * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)) ): ($report->item_cost  * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)));
                                    $cash = empty($report->item_cost) ? empty($closing->item_cost) ? 0 : $closing->item_cost: ($report->item_cost );
                                    $sum+=$result;
                                    $sumCash+=$cash;
                                    }
                                
                                ?>

                            @foreach($reporting as $report)

                            <?php

                                $closing_stock = \DB::table('item_stock_ledgers')
                                ->whereDate('date', $dayClose->day_close)
                                ->where('item_id', $report->item_id)
                                ->where('station', auth()->user()->station)
                                ->first();


                                $closing = \DB::table('item_stock_ledgers')
                                            ->whereDate('date', $to)
                                            ->where('item_id', $report->item_id)
                                            ->where('station', auth()->user()->station)
                                            ->first();


                                    if (empty($closing->item_cost) || null) {
                                            $item_cost = empty($closing->item_cost) ? 0 : $closing->item_cost;
                                        }else{
                                            $item_cost = $closing->item_cost;
                                        }


                                ?>

                            <tr>
                                <td>
                                <?php $date = $dayClose->day_close;
                                    $date1 = new \DateTime($date);
                                    $dayclose = $date1->format('m/d/Y');
                                ?>
                                <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                    <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                    <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                    <input type="text" name="opening" value="{{$report->item_opening_stock}}" hidden>
                                    <input type="text" name="closing" value="{{$report->item_closing_stock}}" hidden>
                                    <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                </form>
                                <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{$report->item_name}}</a></td>
                                <td>{{$report->item_unit}}</td>
                                <td>
                                <?php 
                                        $opening = \DB::table('item_stock_ledgers')
                                        ->whereDate('date', $from)
                                        ->where('item_id', $report->item_id)
                                        ->where('station', auth()->user()->station)
                                        ->first();
                                    ?>
                                    @convert(empty($opening->item_opening_stock) ? 0 : $opening->item_opening_stock)
                                </td>
                                <td>@convert($report->item_recieved + $report->item_purchases+$report->item_manufacturing)</td>
                                <td>@convert($report->item_issue + $report->item_adjustment+ $report->item_sales+$report->item_wastage+$report->item_cons_manufacturing)</td>
                                <td>
                                <?php 
                                    $closing = \DB::table('item_stock_ledgers')
                                    ->whereDate('date', $to)
                                    ->where('item_id', $report->item_id)
                                    ->where('station', auth()->user()->station)
                                    ->first();
                                ?>
                               @convert( $computer_closing = empty( (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing))) ? 0 : (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing)))
                                </td>
                                <td>
                                    @convert($item_cost)
                                </td>
                                <td>
                                    @convert($item_cost * (empty((($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing))) ? 0  : (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing))))
                                </td>
                            </tr>
                            @endforeach
                                
                                <tr>
                                    <td><strong>GRAND TOTAL</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td> <strong>
                                        
                                    @convert($sum)

                                    </strong></td>
                                </tr>
                            </tbody>

	</table>
</div>
@endif
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
