@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                    </li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('PhysicalStockReport')}}" method="get">
            <input type="text" value="{{request('station')}}" name="station" hidden>
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                </div>
            </form>
        </div>
        </div>
    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Item Stock Ledger -  [Summary with Physical Stock Tracking]</div>
                    
                    <form action="{{route('PrintLedgerDateAllreport')}}" method="GET">
                    <input type="text" value="{{request('station')}}" name="station" hidden>
                    <input type="date" class="form-control" hidden name="start_date" value="{{request('start_date')}}">
                    <input type="date" class="form-control" hidden name="end_date" value="{{request('start_date')}}">
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                        </form>
                    
                </div>
                
                <div style="margin-left:20px;">
                    Report for:  <em>{{request()->start_date == null ? $dayClose->day_close : request()->start_date . " / " . request()->end_date}}</em>, Station: {{request('station')}}
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Op. Stock</th>
                                <th>Received</th>
                                <th>Purch.</th>
                                <th>Manuf</th>
                                <th>Issue</th>
                                <th>Sale</th>
                                <th>Adjust.</th>
                                <th>Wastage</th>
                                <th>Manuf. <br> Consum</th>
                                <th>Closing <br> Stock</th>
                                <th>Manual <br> Cl. Stock</th>
                                <th>Variance</th>
                                <!-- @if(auth()->user()->role == "Administrator")
                                <th></th>
                                @endif -->
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($reports as $report)
                                <tr>
                                    <td>
                                    <?php $date = $dayClose->day_close;
                                        $date1 = new \DateTime($date);
                                        $dayclose = $date1->format('m/d/Y');
                                    ?>
                                    <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                        <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                        <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                        <input type="text" name="opening" value="{{$report->item_opening_stock}}" hidden>
                                        <input type="text" name="closing" value="{{$report->item_closing_stock}}" hidden>
                                        <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                    </form>
                                    <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{@ucwords(@strtolower($report->item_name))}}</a></td>
                                    <td>
                                        @if(empty($report->item_category) || null)
                                            <?php $itm = \DB::table('items')->where('id',$report->item_id)->first();
                                                \DB::table('item_stock_ledgers')->where('station', request('station'))
                                                ->whereDate('date', $dayClose->day_close)->where('item_id', $report->item_id )->update([
                                                    'item_category' => empty($itm->item_category) ? "Uncategorized" : $itm->item_category
                                                ]);

                                            ?>
                                            {{@ucwords( $report->item_category )}}
                                        @else
                                             {{@ucwords($report->item_category )}}
                                        @endif
                                    </td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>@convert($report->item_opening_stock)</td>
                                    <td>@convert($report->item_recieved)</td>
                                    <td>@convert($report->item_purchases)</td>
                                    <td>@convert($report->item_manufacturing)</td>
                                    <td>@convert($report->item_issue)</td>
                                    <td>@convert($report->item_sales)</td>
                                    <td>@convert($report->item_adjustment)</td>
                                    <td>@convert($report->item_wastage)</td>
                                    <td>@convert($report->item_cons_manufacturing)</td>
                                    <td>@convert((($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))</td>
                                    <td>@convert($report->item_manual_closing_stock)</td>
                                    <td>@convert($report->item_manual_closing_stock - (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))</td>
                                    @if(auth()->user()->role == "Administrator")
                                    <!-- <td><a href="{{route('RemoveItem', $report->id)}}">Remove</a></td> -->
                                    @endif
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->
                          

</div>
<!-- Content wrapper end -->


@endsection