@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item"><a href="index.html">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Item Stock Ledger</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('stockLedgerSort')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" max="{{$dayClose->day_close}}" value="{{request('start_date')}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" max="{{$dayClose->day_close}}" value="{{request('end_date')}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Item Stock Ledger -  [Summary with Physical Stock Tracking]</div>
                                        
                                        <form action="{{route('PrintLedger')}}" method="GET">
                                        <input type="date" class="form-control" value="{{request('start_date')}}" hidden name="start_date">
                                        <input type="date" class="form-control" value="{{request('end_date')}}" hidden name="end_date">
                                        <button class="btn btn-outline-primary"> <i class="icon-print"></i>Print</button>
                                        </form>
                                       
                                    </div>
                                    
                                    <div style="margin-left:20px;">
                                        Report for:  <em>{{request()->start_date . "/" . request()->end_date}}</em>, Station: <?=auth()->user()->station?>
                                    </div>
                                    
									<div class="card-body">
                                    <div class="table-responsive">
                                    <table id="copy-print-csv" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Items</th>
                                                    <th>UOM</th>
                                                    <th>Opening <br> Stock</th>
                                                    <th>Received</th>
                                                    <th>Purch.</th>
                                                    <th>Manuf</th>
                                                    <th>Issue</th>
                                                    <th>Sale</th>
                                                    <th>Adjust.</th>
                                                    <th>Wastage</th>
                                                    <th>Manuf. <br> Consum</th>
                                                    <th>Closing Stock</th>
                                                    <th>Manual <br> Closing Stock</th>
                                                    <th>Variance</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($reports->chunk(50) as $row)
                                                    @foreach($row as $report)
                                                    <tr>
                                                        <td><?php $date = $dayClose->day_close;
                                                                $date1 = new \DateTime($date);
                                                                $dayclose = $date1->format('m/d/Y');
                                                            ?>
                                                            <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                                            <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                                                <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                                                <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                                            </form>
                                                            <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{@ucwords(@strtolower($report->item_name))}}</a></td>
                                                        <td>{{$report->item_unit}}</td>
                                                        <td>
                                                            <?php 
                                                               $opening = \DB::table('item_stock_ledgers')
                                                                ->whereDate('date', $from)
                                                                ->where('item_id', $report->item_id)
                                                                ->where('station', auth()->user()->station)
                                                                ->first();
                                                            ?>
                                                            {{empty($opening->item_opening_stock) ? 0 : $opening->item_opening_stock}}
                                                        </td>
                                                        <td>@convert($report->item_recieved)</td>
                                                        <td>@convert($report->item_purchases)</td>
                                                        <td>@convert($report->item_manufacturing)</td>
                                                        <td>@convert($report->item_issue)</td>
                                                        <td>@convert($report->item_sales)</td>
                                                        <td>@convert($report->item_adjustment)</td>
                                                        <td>@convert($report->item_wastage)</td>
                                                        <td>@convert($report->item_cons_manufacturing)</td>
                                                        <td>
                                                        <?php 
                                                               $closing = \DB::table('item_stock_ledgers')
                                                                ->whereDate('date', $to)
                                                                ->where('item_id', $report->item_id)
                                                                ->where('station', auth()->user()->station)
                                                                ->first();
                                                            ?>
                                                            @convert( $computer_closing = empty( (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing))) ? 0 : (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing)))
                                                        </td>
                                                        <td>
                                                            <?php
                                                             $manual_closing = \DB::table('item_stock_ledgers')
                                                             ->whereDate('date', $to)
                                                             ->where('item_id', $report->item_id)
                                                             ->where('station', auth()->user()->station)
                                                             ->first();
                                                            ?>
                                                            @convert($manual_closing = empty($manual_closing->item_manual_closing_stock) ? 0 : $manual_closing->item_manual_closing_stock)
                                                        </td>
                                                        <td>
                                                           @convert($manual_closing - $computer_closing)
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>                            
                                </div>
                                <!-- end Table -->
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->


@endsection