@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Item Stock Ledger</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('stockLedgerSortSummary')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Item Stock Ledger -  [Summary with Physical Stock Tracking]</div>
                    
                    <form action="{{route('PrintLedgerSummaryDate')}}" method="GET">
                            <input hidden type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>">
                            <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                        </form>
                    
                </div>
                
                <div style="margin-left:20px;">
                    Report for Today:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Station: <?=auth()->user()->station?>
                </div>

               
                
                <div class="card-body">
                    @if($reporting->isEmpty())
                    <?php $last_stock = \DB::table('item_stock_ledgers')->where('date', $dayClose->day_close)->where('station', auth()->user()->station)->get(); ?>
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>UOM</th>
                                <th>Opening Stock</th>
                                <th>Receipts</th>
                                <th>Issues</th>
                                <th>Closing Stock</th>
                                <th>Rate</th>
                                <th>Item value</th>
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($last_stock as $report)

                                <tr>
                                    <td>
                                    <?php $date = $dayClose->day_close;
                                        $date1 = new \DateTime($date);
                                        $dayclose = $date1->format('m/d/Y');
                                    ?>
                                    <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                        <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                        <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                        <input type="text" name="opening" value="{{$report->item_opening_stock}}" hidden>
                                        <input type="text" name="closing" value="{{$report->item_closing_stock}}" hidden>
                                        <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                    </form>
                                    <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{$report->item_name}}</a></td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>
                                    <?php 
                                            $opening = \DB::table('item_stock_ledgers')
                                            ->whereDate('date', $dayClose->day_close)
                                            ->where('item_id', $report->item_id)
                                            ->where('station', auth()->user()->station)
                                            ->first();
                                        ?>
                                        <td>@convert((($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))</td>
                                    </td>
                                    <td>@convert(0)</td>
                                    <td>@convert(0)</td>
                                    <td>
                                    <td>@convert((($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))</td>
                                    </td>
                                    <td>
                                        @convert($report->item_cost)
                                    </td>
                                    <td>
                                       @convert($report->item_cost * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)))
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                    @else
                <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>UOM</th>
                                <th>Opening Stock</th>
                                <th>Receipts</th>
                                <th>Issues</th>
                                <th>Closing Stock</th>
                                <th>Rate({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                <th>Item value({{empty($app->currency) ? "GHS" : $app->currency}})</th>
                                </tr>
                        </thead>
                        <tbody>

                    <?php $sum = 0;
                    $sumCash = 0; 
                        foreach ($reporting as $report) {

                            $closing = \DB::table('item_stock_ledgers')
                                ->whereDate('date', $dayClose->day_close)
                                ->where('item_id', $report->item_id)
                                ->where('station', auth()->user()->station)
                                ->first();

                            $result = empty($report->item_cost) ? (empty($closing->item_cost) ? 0 : $closing->item_cost * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)) ): ($report->item_cost  * (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing)));
                            $cash = empty($report->item_cost) ? empty($closing->item_cost) ? 0 : $closing->item_cost: ($report->item_cost );
                            $sum+=$result;
                            $sumCash+=$cash;
                            }
                        
                        ?>

                        @foreach($reporting as $report)

                        <?php

                        $closing_stock = \DB::table('item_stock_ledgers')
                        ->whereDate('date', $dayClose->day_close)
                        ->where('item_id', $report->item_id)
                        ->where('station', auth()->user()->station)
                        ->first();


                        $closing = \DB::table('item_stock_ledgers')
                                    ->whereDate('date', $to)
                                    ->where('item_id', $report->item_id)
                                    ->where('station', auth()->user()->station)
                                    ->first();


                            if (empty($closing->item_cost) || null) {
                                    $item_cost = empty($closing->item_cost) ? 0 : $closing->item_cost;
                                }else{
                                    $item_cost = $closing->item_cost;
                                }


                        ?>

                        <tr>
                            <td>
                            <?php $date = $dayClose->day_close;
                                $date1 = new \DateTime($date);
                                $dayclose = $date1->format('m/d/Y');
                            ?>
                            <form method="get" action="{{route('productHistory')}}" id="form-id<?= $report->item_id?>">
                                <input type="text" name="item_name" value="{{$report->item_name}}" hidden>
                                <input type="text" name="item_id" value="{{$report->item_id}}" hidden>
                                <input type="text" name="opening" value="{{$report->item_opening_stock}}" hidden>
                                <input type="text" name="closing" value="{{$report->item_closing_stock}}" hidden>
                                <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                            </form>
                            <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->item_id?>').submit();">{{$report->item_name}}</a></td>
                            <td>{{$report->item_unit}}</td>
                            <td>
                            <?php 
                                    $opening = \DB::table('item_stock_ledgers')
                                    ->whereDate('date', $from)
                                    ->where('item_id', $report->item_id)
                                    ->where('station', auth()->user()->station)
                                    ->first();
                                ?>
                                @convert(empty($opening->item_opening_stock) ? 0 : $opening->item_opening_stock)
                            </td>
                            <td>@convert($report->item_recieved + $report->item_purchases+$report->item_manufacturing)</td>
                            <td>@convert($report->item_issue + $report->item_adjustment+ $report->item_sales+$report->item_wastage+$report->item_cons_manufacturing)</td>
                            <td>
                            <?php 
                                    $closing = \DB::table('item_stock_ledgers')
                                    ->whereDate('date', $to)
                                    ->where('item_id', $report->item_id)
                                    ->where('station', auth()->user()->station)
                                    ->first();
                                ?>
                               @convert( $computer_closing = empty( (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing))) ? 0 : (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing)))

                            </td>
                            <td>
                            @convert($item_cost)
                            </td>
                            <td>
                            @convert($item_cost * (empty((($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing))) ? 0  : (($report->item_opening_stock+$report->item_recieved+$report->item_purchases+$report->item_manufacturing) - ($report->item_issue+$report->item_sales+$report->item_adjustment+$report->item_wastage+$report->item_cons_manufacturing))))
                            </td>
                        </tr>
                        @endforeach
                            </tbody>
                    </table>
                    </div>
                    @endif
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection