@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <!-- <li class="breadcrumb-item active" aria-current="page">Item Stock Ledger | <a href="{{route('reloadLedger')}}">Reload ledger</a> | -->
                        <li class="breadcrumb-item"><a href="#"><a href="#">Item_stock_ledger</a></li>
                    </li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">   
        <!-- Top Actions - DateRange and Buttons -->
        <!-- <form action="{{route('stockLedgerSort')}}" method="get"> -->
        <form action="{{route('itemstockledger.index')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <div style="margin-right:10px"><small>From</small></div>
                    <input type="date" class="form-control" name="start_date" value="{{request('start_date')}}" max="{{$dayClose->day_close}}">
                    <div style="margin-right:10px; margin-left:10px"><small>to</small></div>
                    <input type="date" class="form-control" name="end_date" value="{{request('end_date')}}" max="{{$dayClose->day_close}}">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info"><i class="icon-download1"></i> Report</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
        </div>
    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Item Stock Ledger -  [Summary with Physical Stock Tracking]</div>
                    
                    <form action="{{route('PrintLedger')}}" method="GET">
                    <input type="date" class="form-control" value="{{request('start_date')}}" hidden name="start_date">
                    <input type="date" class="form-control" value="{{request('end_date')}}" hidden name="end_date">
                            <button class="btn btn-outline-primary"> <i class="icon-printer"></i> Print</button>
                    </form>
                    
                </div>
                
                <div style="margin-left:20px;">
                    Report for: <em>{{request()->start_date == null ?  $dayClose->day_close : request()->start_date . " / " . request()->end_date}}</em>, Station: <?=auth()->user()->station?>
                </div>
                
                <div class="card-body">
                <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Opening <br> Stock</th>
                                <th>Received</th>
                                <th>Purchase</th>
                                <th>Manufuring</th>
                                <th>Issue</th>
                                <th>Sale</th>
                                <th>Adjustment</th>
                                <th>Wastage</th>
                                <th>Manuf. <br> Consumption</th>
                                <th>Closing <br> Stock</th>
                                <th>Phys. <br> stock</th>
                                <th>Variance</th>
                                <!-- @if(auth()->user()->role == "Administrator")
                                <th></th> 
                                @endif -->
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($reports->chunk(20) as $row)
                                @foreach($row as $report)
                                @if(in_array(auth()->user()->station, json_decode($report->inactive_station)) == true)
                                    @continue
                                @endif

                                <?php

                                        $physical_stock = \DB::table('stock_variances')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                        ->WhereDate('date', $to)
                                        ->first();
                                                           
                                            if(empty($physical_stock)){
                                                $physical_stock = null;
                                            }else {
                                                $physical_stock = $physical_stock->physical_stock;
                                            }

                                        ?>

                                <tr>
                                    <td>

                                        <form method="get" action="{{route('StockFilter')}}" id="form-id<?= $report->id?>">
                                            <input type="text" name="item_id" value="{{$report->id}}" hidden>
                                            <input type="date" class="form-control" name="start_date" hidden value="{{request('start_date')}}" max="{{$dayClose->day_close}}">
                                            <input type="date" class="form-control" name="end_date" hidden value="{{request('end_date')}}" max="{{$dayClose->day_close}}">
                                        </form>
                                        <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->id?>').submit();">{{@ucwords(@strtolower($report->item_name))}}</a>
                                    </td>
                                    <td>{{@ucwords($report->item_category )}}</td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>
                                    @if(request('start_date') == request('end_date'))
                                    @convert( $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_in') - 
                                        \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_out')
                                        )
                                    @else

                                    @convert( $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_in') - 
                                        \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_out')
                                        )

                                    @endif

                                    </td>
                                    <td>@convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Receipts")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $purchase =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                        ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Purchases")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Manufacture")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Issues")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Sales")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>@convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Adjustments")
                                        ->sum('stock_out')                                         
                                        )</td>
                                    <td>
                                    @convert(
                                         $wastage =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date', request('start_date'))
                                         ->WhereDate('date', request('end_date'))
                                        ->where('description', "Wastages")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                        ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "consumptions")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>

                                    <?php

                                    $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                    ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                    ->sum('stock_in');

                                    $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                    ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                    ->sum('stock_out');

                                    ?>
                                   

                                        @convert($closing = ($stock_in - $stock_out) + $balance_b_f) 
                                        
                                    </td>
                                    <td>@convert($physical_stock)</td>

                                    <td>@convert($physical_stock - $closing)</td>
                                
                                </tr>
                                @endforeach
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->
                          

</div>
<!-- Content wrapper end -->


@endsection