@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Manufacturing Cost</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
        <form action="{{route('ManufacturingCostDate')}}" method="get">
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                        <button class="btn btn-info">Reports</button>
                    </div>
                </div>
                <!-- Field wrapper end -->
                
            </div>
        </form>
        </div>
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Cost of Manufactured Items - [Item Manufacturing Report Summary]</div>
                                        
                                        <form action="{{route('ManufacturingDatePrint')}}" method="GET">
                                                <input type="text" name="date" value="<?= request()->date == null ? date('m/d/Y', strtotime($dayClose->day_close)) . " - " . date('m/d/Y', strtotime($dayClose->day_close))   : request()->date ?>" hidden>
                                                <button class="btn btn-outline-primary"> <i class="icon-print"></i> Print</button>
                                        </form>
                                    </div>
                                    
                                    <div style="margin-left:20px;">
                                        Date:  <em>{{request()->date == null ? $dayClose->day_close : request()->date }}</em>, Issue Station: <?=auth()->user()->station?>
                                    </div>
                                    
									<div class="card-body">
                                    
                                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Consumption</th>
                                <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                <th>Item Value <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($reports as $report)
                                <tr>
                                    <td>
                                        <?php
                                        $items = \DB::table('items')->where('id', $report->item_id)->first(); 

                                        $date = $dayClose->day_close;
                                        $date1 = new \DateTime($date);
                                        $dayclose = $date1->format('m/d/Y');
                                        
                                        ?>
                                        <form method="get" action="{{route('productHistoryDescription')}}" id="form-id<?= $report->item_id?>">
                                        <input type="text" name="station" hidden>
                                        <input type="text" name="description" value="Wastages" hidden>
                                        <input type="text" name="item_name" value="{{$items->item_name}}" hidden>
                                            <input type="text" name="item_id" value="{{$items->id}}" hidden>
                                            <input type="text" name="date" hidden  value="{{request()->date == null ? $dayclose . " - " . $dayclose : request()->date}}">
                                        </form>
                                        <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$items->id?>').submit();">
                                        {{@ucwords(@strtolower($items->item_name))}}</a>
                                    </td>
                                    <td>{{$items->item_category}}</td>
                                    <td>{{$items->item_unit}}</td>
                                    <td>{{$stock_out = $report->stock_out}}</td>
                                    <td>
                                        {{$cost = $report->cost}}
                                    </td>
                                    <td>{{$stock_out * $cost}}
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->


@endsection