@extends('layouts.fullscreen')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">
    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Opening Stock Balance</li>
                    </ol>
                </nav>
            </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
    </div>
    <!-- Breadcrumb container end -->
</div>
</div>

						<!-- Row start -->
						<div class="row gutters">
							<div class="col-xl-12">
								<!-- Card start -->
								<div class="card">
									<div class="card-header">
                                        <div class="card-title">Stock Taking</div>
                                    </div>
                                
                                    
									<div class="card-body">
                                    <form action="{{route('openingSto')}}" id="stocktaking" method="POST">
                                        
                                        @csrf
                                    <div class="table-responsive">
                                    <table id="basicExample" class="table custom-table">
                                                <thead>
                                                    <tr>
                                                    <th>Items</th>
                                                    <th>Category</th>
                                                    <th>Unit</th>
                                                    <th>Opening stock</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($record_physical as $report)
                                                    @if(in_array(auth()->user()->station, json_decode($report->inactive_station)) == true)
                                                        @continue
                                                    @endif
                                                    <tr>
                                                         <td>{{@ucwords(@strtolower($report->item_name))}}</td>
                                                        <td>{{@ucwords(@strtolower($report->item_category))}}</td>
                                                        <td>{{$report->item_unit}}</td>
                                                       
                                                       
                                                        <td>
                                                            <?php $em =\DB::table('opening_stocks')->where('station', auth()->user()->station)->where('item_id', $report->id)->first();
                                                                if (empty($em)) {
                                                                    $stock = 0;
                                                                }else {
                                                                    $stock = $em->opening_stock;
                                                                }
                                                            ?>                                                      

                                                            <input type="number" min="0" step="0.0001" class="form-control" placeholder="Kindly Enter Physical Stock" name="items[<?=$report->id;?>][issue_item_physical_stock]" value="{{$stock}}">
                                                            <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_item_id]" value="{{$report->id}}" hidden>
                                                           
                                                        </td>
                                                        
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>
                                       <div style="margin-top:12px">
                                         <button class="btn btn-primary" type="button" onclick="physical()">Save</button>
                                       </div>
                                        </form>
									</div>
								</div>
								<!-- Card end -->
                            </div>
						</div>
						<!-- Row end -->

					</div>
					<!-- Content wrapper end -->



                    <script>
                        function physical() {
                            Swal.fire({
                                title: 'Are you sure?',
                                text: "You are updating your opening stock",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                confirmButtonText: 'Yes, Save!'
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    document.getElementById("stocktaking").submit();
                                }
                                })
                        }
                    </script> 
@endsection