@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Physical Stock</h4>
                
            </div>
            <div class="card-body">
            <div class="alert alert-light alert-dismissible fade show" role="alert">
            Physical stock here refers to the actual quantity of goods or products that a company has on hand at a specific point in time. It represents the tangible items that are available for sale or use in the business operations.
            To determine the physical stock in inventory, a company conducts a physical count or stocktake.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
              
            <form id="PhysicalStock">
                @csrf
                <!-- Row start -->
                <div class="row justify-content-between">

                    <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-12">
                                <div class="form-section-header light-bg">Stock Information</div>
                            </div>
                            
                            <div class="col-12">
                                 <!-- Field wrapper start -->
                                 <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="date" class="form-control" name="date" value="<?= $dayClose->day_close ?>">
                                    </div>
                                    <div class="field-placeholder"> Date</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                            <div class="col-12">
                                 <!-- Field wrapper start -->
                                 <div class="field-wrapper">
                                    <div class="input-group">
                                       <textarea name="remark" class="form-control" cols="10"></textarea>
                                    </div>
                                    <div class="field-placeholder"> Remark</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                        </div>
                        <!-- Row end -->

                    </div>
                    
                    <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">
                     
                        <!-- Row start -->
                        <div class="row gutters">

                        <div class="col-12">
                                <div class="form-section-header light-bg">Other Information</div>
                            </div>

                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <select class="select-single js-states" required name="adjusted_item" title="Select Term" data-live-search="true">
                                    <option disabled selected> - Select Item -</option>
                                        @foreach($items as $item)
                                        <option value="{{$item -> item_name}} - {{$item -> id}}">{{@ucwords(@strtolower($item -> item_name))}}</option>
                                        @endforeach
                                    </select>
                                    <div class="field-placeholder">Item</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>
                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">
                                        <input type="number" name="adjusted_qty" class="form-control" step="0.001">
                                    </div>
                                    <div class="field-placeholder">Physical Quantity</div>
                                </div>
                                <!-- Field wrapper end -->
                            </div>


                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                <button class="btn btn-outline-primary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to List</button> 
                                </div>
                                <!-- Field wrapper end -->
                            </div>

                        </div>
                        <!-- Row end -->

                    </div>

                </div>
                <!-- Row end -->
            </form>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12">
                        <div class="table-responsive" id="tabler">
                            @if(empty(session()->get('cartAdjustment')))
                            <div class="card">
                                <div class="card-body">
                                    <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                            No item added to list. Kindly select Item and add to list. 
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                    
                                </div>
                            </div>
                            @else
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Item</th>
                                        <th>Category</th>
                                        <th>Unit</th>
                                        <th>Phy. Qty</th>
                                        <th>Remark</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach(session()->get('cartAdjustment') as $physical)
                                    <tr>
                                        <td>{{$physical['item_name']}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{$physical['item_unit']}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="{{$physical['item_category']}}" placeholder="Rate" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="tex" class="form-control" value="{{$physical['phyicat_stock']}}" placeholder="Qty" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" class="form-control" value="{{empty($physical['remark']) ? 'No Remark' : $physical['remark']}}" readonly>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button class="btn btn-outline-light" id="{{$physical['id']}}" type="button" onclick="deleteDock(this.id)">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                   
                                </tbody>
                            </table>
                            @endif
                        </div>

                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button class="btn btn-outline-primary ms-1" onclick="confirmReceipt()" >Save stock taken</button>
                                <button class="btn btn-danger ms-1" onClick="confirmClose()">Void</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->





<script>
    
    function getUnit(){
        $("#unit-re").load(" #unit-re");
        var e = document.getElementById("ddlViewBy");
        var strUser = e.value;
        var split_arrary = strUser.split(" - ")

        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                var res = JSON.parse(this.responseText)
                var sel = document.getElementById('unit-listing');

                for(var i = 0; i < res.length; i++) {
                    var opt = document.createElement('option');
                    opt.innerHTML = res[i];
                    opt.value = res[i];
                    sel.appendChild(opt);
                }
            }
            xhttp.open("GET", "/dashboard/get-unit/"+split_arrary[1]);
            xhttp.send();
    }



    function deleteDock(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/physical-cart/remove/"+id);
            xhttp.send();
    }

    function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/dashboard/customer-note/" + note);
            xhttp.send();
        }


    $("#PhysicalStock").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('Adjustment.store')}}",
                dataType: "json",
                data: $('#PhysicalStock').serialize(),
                success: function(data){
                    $("#tabler").load(" #tabler");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 6000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Adding to list, Please wait....'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


    function confirmReceipt() {
        Swal.fire({
            title: 'Critical Stock Operation',
            text: "Are you sure you want to proceed with saving the changes? This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('save.physical')}}";
            }
            })
    }


    function saveOnlyAndPrint(){
       document.getElementById('savetype').value = 1
    }
    function saveOnly(){
       document.getElementById('savetype').value = 0
    }


    function confirmClose() {
        Swal.fire({
            title: ' Irreversible Action',
            text: "Are you sure you want to clear the item from the list?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, clear!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearPhysical')}}";
            }
            })
    }

    </script>

@endsection