<!doctype html>
<html lang="en">

<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Meta -->
<meta name="description" content="Andas solution stock report">
<meta name="author" content="Prince Asamoah">
<link rel="shortcut icon" href="img/fav.png">

<!-- Title -->
<title>Item Stock Ledger Report -  {{request()->date == null ? $dayClose->day_close : request()->date}}</title>

<!-- Date Range CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">


<!-- Uploader CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

<!-- *************
************ Common Css Files *************
************ -->
<!-- Bootstrap css -->
<link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

<!-- Icomoon Font Icons css -->
<link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

<!-- Main css -->
<link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

<!-- fontAwesome -->
<link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


<!-- Data Tables -->
<link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
<link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

<!-- Sweet Alert-->
<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


<script src="{{asset('assets/js/ajax.min.js')}}"></script>

<!-- *************
************ Vendor Css Files *************
************ -->

<!-- Bootstrap Select CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

<!-- Mega Menu -->
<link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

<!-- Search Filter JS -->
<link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
<link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
</head>

<style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">
<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
        <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
        <a href="#" class="logo">
        <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
        </a>
        </div>
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <address class="text-right">
            Printed by: {{auth()->user()->name}} <br>
            Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
            </address>
    </div>
</div>
<!-- Row end -->
</div>

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
<div class="invoice-details">
<address class="m-0">
<strong>{{$app->app_name}}</strong>,<br>
<?= @strtoupper("Item Stock Ledger -  [Summary with Physical Stock Tracking]") ?><br>
REPORT FOR: <?=@strtoupper(auth()->user()->station);?>
</address>

<div class="invoice-num">
<div>Report Date</div>
<div> {{request()->start_date . "/" . request()->end_date}}</div>
</div>
</div>
</div>
</div>
<!-- Row end -->

<div class="table-responsive">
<table class="table table-bordered table-striped m-0">
<thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Op. Stock</th>
                                <th>Received</th>
                                <th>Purch.</th>
                                <th>Manuf</th>
                                <th>Issue</th>
                                <th>Sale</th>
                                <th>Adjust.</th>
                                <th>Wastage</th>
                                <th>Manuf. <br> Consum</th>
                                <th>Closing <br> Stock</th>
                                <th>Phys. stock</th>
                                <th>Variance</th>
                                <!-- @if(auth()->user()->role == "Administrator")
                                <th></th>
                                @endif -->
                                </tr>
                        </thead>
                            <tbody>
                                @foreach($reports->chunk(15) as $row)
                                @foreach($row as $report)
                                @if(in_array(auth()->user()->station, json_decode($report->inactive_station)) == true)
                                    @continue
                                @endif

                                <?php

                                        $physical_stock = \DB::table('stock_variances')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                        ->WhereDate('date', $to)
                                        ->first();
                                                           
                                            if(empty($physical_stock)){
                                                $physical_stock = null;
                                            }else {
                                                $physical_stock = $physical_stock->physical_stock;
                                            }

                                        ?>

                                <tr>
                                    <td>

                                        <form method="get" action="{{route('StockFilter')}}" id="form-id<?= $report->id?>">
                                            <input type="text" name="item_id" value="{{$report->id}}" hidden>
                                            <input type="date" class="form-control" name="start_date" hidden value="{{request('start_date')}}" max="{{$dayClose->day_close}}">
                                            <input type="date" class="form-control" name="end_date" hidden value="{{request('end_date')}}" max="{{$dayClose->day_close}}">
                                        </form>
                                        <a href="javascript:void(0)" onclick="document.getElementById('form-id<?=$report->id?>').submit();">{{@ucwords(@strtolower($report->item_name))}}</a>
                                    </td>
                                    <td>{{@ucwords($report->item_category )}}</td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>
                                    @if(request('start_date') == request('end_date'))
                                    @convert( $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_in') - 
                                        \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_out')
                                        )
                                    @else

                                    @convert( $balance_b_f =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_in') - 
                                        \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)->whereDate('date', '<', request('start_date'))->sum('stock_out')
                                        )

                                    @endif

                                    </td>
                                    <td>@convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Receipts")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $purchase =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                        ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Purchases")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Manufacture")
                                        ->sum('stock_in')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Issues")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Sales")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>@convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "Adjustments")
                                        ->sum('stock_out')                                         
                                        )</td>
                                    <td>
                                    @convert(
                                         $wastage =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date', request('start_date'))
                                         ->WhereDate('date', request('end_date'))
                                        ->where('description', "Wastages")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>
                                    @convert(
                                         $recieved =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                         ->WhereDate('date','>=', request('start_date'))
                                        ->WhereDate('date','<=', request('end_date'))
                                        ->where('description', "consumptions")
                                        ->sum('stock_out')                                         
                                        )
                                    </td>
                                    <td>

                                    <?php

                                    $stock_in =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                    ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                    ->sum('stock_in');

                                    $stock_out =  \DB::table('stock_transactions')->where('station', auth()->user()->station)->where('item_id', $report->id)
                                    ->WhereDate('date','>=', request('start_date'))
                                    ->WhereDate('date','<=', request('end_date'))
                                    ->sum('stock_out');


                                   
                                    ?>
                                   

                                        @convert($closing = ($stock_in - $stock_out) + $balance_b_f) 
                                        
                                    </td>
                                    <td>@convert($physical_stock)</td>

                                    <td>@convert($physical_stock - $closing)</td>
                                
                                </tr>
                                @endforeach
                                @endforeach
                            </tbody>
                    </table>
                    </div>


</div>
</div>



<!-- *************
************ Required JavaScript Files *************
************* -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="{{asset('assets/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset('assets/js/modernizr.js')}}"></script>
<script src="{{asset('assets/js/moment.js')}}"></script>

<!-- *************
************ Vendor Js Files *************
************* -->

<!-- Sweet Alerts js -->
<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>

<!-- Megamenu JS -->
<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

<!-- Slimscroll JS -->
<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

<!-- Search Filter JS -->
<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

<!-- Apex Charts -->
<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

<!-- Circleful Charts -->
<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


<!-- Bootstrap Select JS -->
<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


<!-- Data Tables -->
<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>

<!-- Custom Data tables -->
<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

<!-- Download / CSV / Copy / Print -->
<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

<!-- Dropzone JS -->
<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

<!-- Date Range JS -->
<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

<!-- Main Js Required -->
<script src="{{asset('assets/js/main.js')}}"></script>

</body>

</html>
