<!doctype html>
<html lang="en">

<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

<!-- Meta -->
<meta name="description" content="Andas solution stock report">
<meta name="author" content="Prince Asamoah">
<link rel="shortcut icon" href="img/fav.png">

<!-- Title -->
<title>Stock Report -  {{request()->start_date == null ? $dayClose->day_close : request()->start_date}}</title>

<!-- Date Range CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">


<!-- Uploader CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

<!-- *************
************ Common Css Files *************
************ -->
<!-- Bootstrap css -->
<link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

<!-- Icomoon Font Icons css -->
<link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

<!-- Main css -->
<link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

<!-- fontAwesome -->
<link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


<!-- Data Tables -->
<link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
<link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

<!-- Sweet Alert-->
<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


<script src="{{asset('assets/js/ajax.min.js')}}"></script>

<!-- *************
************ Vendor Css Files *************
************ -->

<!-- Bootstrap Select CSS -->
<link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

<!-- Mega Menu -->
<link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

<!-- Search Filter JS -->
<link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
<link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
</head>

<style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">
<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
        <a href="#" onclick="window.history.go(-1); return false" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
        <a href="#" class="logo">
        <img src="/assets/img/{{$app->app_logo}}" alt="logo" style="max-width:70px;">
        </a>
        </div>
        <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <address class="text-right">
            Printed by: {{auth()->user()->name}} <br>
            Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
            </address>
    </div>
</div>
<!-- Row end -->
</div>

<!-- Row start -->
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
<div class="invoice-details">
<address class="m-0">
<strong>{{$app->app_name}}</strong>,<br>
<?= @strtoupper("Item Stock Ledger -  [Summary with Physical Stock Tracking]") ?><br>
REPORT FOR: <?=@strtoupper(request('station'));?>
</address>

<div class="invoice-num">
<div>Report Date</div>
<div> {{request()->start_date == null ? $dayClose->day_close : request()->start_date . " / " . request('end_date')}}</div>
</div>
</div>
</div>
</div>
<!-- Row end -->

<div class="table-responsive">
<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
        <th>Items</th>
        <th>UOM</th>
        <th>opening <br> stock</th>
        <th>Received</th>
        <th>Purch.</th>
        <th>Manuf</th>
        <th>Issue</th>
        <th>Sale</th>
        <th>Adjust.</th>
        <th>Wastage</th>
        <th>Manuf. <br> Consum</th>
        <th>Closing Stock</th>
        <th>Manual <br> Closing Stock</th>
        <th>Variance</th>
        </tr>
    </thead>
    <tbody>
    @foreach($reports as $report)
        <tr>
            <td>
     {{@ucwords(@strtolower($report->item_name))}}</td>
            <td>{{$report->item_unit}}</td>
            <td>
                <?php 
                    $opening = \DB::table('item_stock_ledgers')
                    ->whereDate('date', $from)
                    ->where('item_id', $report->item_id)
                    ->where('station', request('station'))
                    ->first();
                ?>
                {{empty($opening->item_opening_stock) ? 0 : $opening->item_opening_stock}}
            </td>
            <td>@convert($report->item_recieved)</td>
            <td>@convert($report->item_purchases)</td>
            <td>@convert($report->item_manufacturing)</td>
            <td>@convert($report->item_issue)</td>
            <td>@convert($report->item_sales)</td>
            <td>@convert($report->item_adjustment)</td>
            <td>@convert($report->item_wastage)</td>
            <td>@convert($report->item_cons_manufacturing)</td>
            <td>
            <?php 
                    $closing = \DB::table('item_stock_ledgers')
                    ->whereDate('date', $to)
                    ->where('item_id', $report->item_id)
                    ->where('station', request('station'))
                    ->first();
                ?>
                @if(empty($closing))
                    @convert( $computer_closing = 0)
                @else
                    @convert( $computer_closing = empty( (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing))) ? 0 : (($closing->item_opening_stock+$closing->item_recieved+$closing->item_purchases+$closing->item_manufacturing) - ($closing->item_issue+$closing->item_sales+$closing->item_adjustment+$closing->item_wastage+$closing->item_cons_manufacturing)))
                @endif
            </td>
            <td>
                <?php
                    $manual_closing = \DB::table('item_stock_ledgers')
                    ->whereDate('date', $to)
                    ->where('item_id', $report->item_id)
                    ->where('station', request('station'))
                    ->first();
                ?>
                @if(empty($manual_closing))
                    @convert($manual_closing = 0)
                @else
                    @convert($manual_closing = empty($manual_closing->item_manual_closing_stock) ? 0 : $manual_closing->item_manual_closing_stock)
                @endif
            </td>
            <td>
                @convert($manual_closing - $computer_closing)
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
</div>


</div>
</div>



<!-- *************
************ Required JavaScript Files *************
************* -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="{{asset('assets/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset('assets/js/modernizr.js')}}"></script>
<script src="{{asset('assets/js/moment.js')}}"></script>

<!-- *************
************ Vendor Js Files *************
************* -->

<!-- Sweet Alerts js -->
<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>

<!-- Megamenu JS -->
<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

<!-- Slimscroll JS -->
<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

<!-- Search Filter JS -->
<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

<!-- Apex Charts -->
<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

<!-- Circleful Charts -->
<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


<!-- Bootstrap Select JS -->
<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


<!-- Data Tables -->
<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>

<!-- Custom Data tables -->
<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

<!-- Download / CSV / Copy / Print -->
<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

<!-- Dropzone JS -->
<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

<!-- Date Range JS -->
<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

<!-- Main Js Required -->
<script src="{{asset('assets/js/main.js')}}"></script>

</body>

</html>
