@extends('layouts.fullscreen')

@section('content')

					<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="/">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Trash Bucket</li>
                    </ol>
                </nav>
            </div>
        
        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12">
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Trash Bucket</div>
                    <span style="float:right">Record Wastage for: <em><?= request()->date == null ? $dayClose->day_close : request()->date; ?></em>, Station: <?=auth()->user()->station?></span>
                </div>
                
                
                <div class="card-body">

                <div class="alert alert-light alert-dismissible fade show" role="alert">
                Used to record loss or reduction of inventory due to various reasons, resulting in a decrease in the quantity or value of stock. Wastages can occur in different forms and industries, such as spoilage, obsolescence, breakage, expiration, theft, or damage.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                <form action="{{route('save.wastage')}}" method="POST" id="stocktaking">
                
                <div class="row gutters">
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                        <div class="input-group"  style="width: 300px;">														
                                <input type="date" min="{{date('Y-m-d', strtotime('-1 day', strtotime($dayClose->day_close)))}}" max="<?= $dayClose->day_close ?>" class="form-control" value="<?= $dayClose->day_close ?>" name="date">
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                </div>
                    @csrf
                <div class="table-responsive table-sm">
                <table id="basicExample" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Items</th>
                                <th>Category</th>
                                <th>UOM</th>
                                <th>Wastage</th>
                                <th>Remark</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($record_trash as $report)
                                <tr>
                                <td>{{@ucwords(@strtolower($report->item_name))}}</td>
                                    <td>{{@ucwords(@strtolower($report->item_category))}}</td>
                                    <td>{{$report->item_unit}}</td>
                                    <td>
                                       
                                        <input type="number" min="0" step="0.0001" class="form-control" placeholder="Kindly Enter Wastage" name="items[<?=$report->id;?>][issue_item_wastage]">
                                        <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_station]" value="{{auth()->user()->station}}" hidden>
                                        <input type="text" class="form-control" name="items[<?=$report->id;?>][issue_item_id]" value="{{$report->id}}" hidden>
                                       
                                    </td>
                                    <td><textarea name="items[<?=$report->id;?>][comment]" class="form-control" id="" cols="30" rows="2"></textarea></td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                    <div style="margin-top:12px">
                        <button type="button" class="btn btn-primary" onclick="trash()">Save Trash</button>
                    </div>

                    </form>
                </div>
            </div>
            <!-- Card end -->
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script>
    function trash() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Confirm Trash of Item!'
            }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("stocktaking").submit();
            }
            })
    }
</script> 


@endsection