 @extends('layouts.fullscreen')

@section('content')

<?php session()->put('item_history_date', request('date')) ?>
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-body">
                <div class="py-1">
                <h5>Item History: {{empty(request('item_name')) ? $item : request('item_name')}}</h5> {{session()->get('item_history_date')}}
                <a href="{{route('ItemHistoryPrint', $item_id)}}" style="float:right" class="btn btn-outline-primary"> <i class="icon-print"></i> Print History</a>
                <p>Date: {{empty(request('date')) ? $dayClose->day_close : request('date')}}</p> 
                </div>
                <!-- Faq start -->
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Recieved Items
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                @if($incomingvouchers->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Item Recieved
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>UOM</th>
                                                <th>Issued From</th>
                                                <th>Rate</th>
                                                <th>Item Value</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($incomingvouchers as $req)
                                            <tr>
                                                <td>{{$req->issue_item}}</td>
                                                <td>@convert($req->issue_quantity)</td>
                                                <td>{{$req->issue_unit}}</td>
                                                <td>{{$req->station}}</td>
                                                <td>@convert($req->issue_rate)</td>
                                                <td>@convert($req->issue_total_cost)</td>
                                                <td>{{$req->issue_date}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne8" aria-expanded="true" aria-controls="collapseOne">
                                Goods Receipt Note
                            </button>
                        </h2>
                        <div id="collapseOne8" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                @if($good_receipt->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    Goods Receipt Note
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Unit</th>
                                                <th>Purchased by</th>
                                                <th>Rate</th>
                                                <th>Item Value</th>
                                                <th>Note</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($good_receipt as $req)
                                            <tr>
                                                <td>{{$req->g_r_item}}</td>
                                                <td>@convert($req->g_r_quantity)</td>
                                                <td>{{$req->g_r_unit}}</td>
                                                <td>{{$req->name}}</td>
                                                <td>@convert($req->g_r_rate)</td>
                                                <td>@convert($req->g_r_total)</td>
                                                <td>{!! empty($req->g_r_note) ? '<span class="badge bg-success">' . "No Note" . '</span>' :   $req->g_r_note !!}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Purchases
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if($purchases->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Item Purchased
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>Station</th>
                                                <th>Transaction ID</th>
                                                <th>Purchases Vendor</th>
                                                <th>Purchase Date</th>
                                                <th>Item Name (Unit)</th>
                                                <th>Item Category</th>
                                                <th>Quantity</th>
                                                <th>Rate</th>
                                                <th>Item Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($purchases as $req)
                                            <tr>
                                                <td>{{$req->station}}</td>
                                                <td>{{$req->purchase_transaction_id}}</td>
                                                <td>{{$req->purchase_vendor}}</td>
                                                <td>{{$req->purchase_date}}</td>
                                                <td>{{$req->purchase_item}} ({{$req->purchase_unit}})</td>
                                                <td>{!! empty($req->purchase_category) ? '<span class="badge bg-success">' . "No Category" . '</span>': $req->purchase_category !!}</td>
                                                <td>{{$req->purchase_quantity}}</td>
                                                <td>@convert($req->purchase_rate)</td>
                                                <td>@convert($req->purchase_total)</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                Issue Register
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if($outgoingVoucher->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Transfers Made
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>Transaction ID</th>
                                                <th>Issue to</th>
                                                <th>Issue By</th>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Unit</th>
                                                <th>Issued From</th>
                                                <th>Rate</th>
                                                <th>Item Value</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($outgoingVoucher as $req)
                                            <tr>
                                                <td>{{$req->issue_transaction_id}}</td>
                                                <td>{{$req->issue_store}}</td>
                                                <td>{{$req->name}}</td>
                                                <td>{{$req->issue_item}}</td>
                                                <td>@convert($req->issue_quantity)</td>
                                                <td>{{$req->issue_unit}}</td>
                                                <td>{{$req->station}}</td>
                                                <td>@convert($req->issue_rate)</td>
                                                <td>@convert($req->issue_total_cost)</td>
                                                <td>{{$req->issue_date}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                Wastage
                            </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if($wastage->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Wastages
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>Watage</th>
                                                <th>Unit</th>
                                                <th>Remark</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($wastage as $req)
                                            <tr>
                                                <td>{{$req->item_wastage}}</td>
                                                <td>{{$req->item_unit}}</td>
                                                <td>{!!empty($req->wastage_comment) ? '<span class="badge bg-success">' . "No Comment" . '</span>': $req->wastage_comment!!}</td>
                                                <td>{{$req->date}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                Manufacturing Consumption
                            </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if($manufacturingConsumption->count() == 0)
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Manufacturing Consumption
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                @else
                                <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                <thead>
                                                    <tr>
                                                    <th>Date</th>
                                                    <th>Items</th>
                                                    <th>UOM</th>
                                                    <th>Quantity</th>
                                                    <th>Rate <br> <strong>({{empty($app->currency) ? "GHS" : $app->currency}})</strong></th>
                                                    <th>Item Value <br> <strong>({{empty($app->currency) ? "GHS" : $app->currency}})</strong></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($manufacturingConsumption as $report)
                                                    <tr>
                                                        <td>{{$report->date}}</td>
                                                        <td>{{$report->item_name}}</td>
                                                        <td>{{$report->item_unit}}</td>
                                                        <td>@convert($report->manufacturing_qty)</td>
                                                        <td>
                                                            <?php $costing = \DB::table('item_stock_ledgers')->where('item_id', $report->item_id)
                                                            ->where('station', auth()->user()->station)
                                                            ->WhereDate('date', $report->date)
                                                            ->first() ?>
                                                            @convert( $new_cost = $costing->item_cost)
                                                        </td>
                                                        <td>@convert($new_cost * $report->manufacturing_qty)</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
	                            </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSix">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                Sales
                            </button>
                        </h2>
                        <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if(empty($sales_today_lists))
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Sales on Item
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @else
                            <div class="table-responsive">
                            <table class="table table-bordered table-striped m-0">
                                        <thead>
                                            <tr>
                                                <th>#Tran. ID</th>
                                                <th>Date</th>
                                                <th>Item</th>
                                                <th>Category</th>
                                                <th>Quantity</th>												
                                                <th>Unit Price</th>
                                                <th>Total Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($sales_today_lists as $list)
                                            <tr>
                                                <td><strong>#{{$list->invoice_number}}</strong></td>
                                                <td>{{$list->created_at}}</td>
                                                <td>
                                                {{$list->invoice_product_name}}
                                                </td>
                                                <td>{{$list->invoice_category}}</td>
                                                <td>
                                                @convert($list->invoice_quantity)
                                                </td>
                                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                Manufacturing
                            </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse" aria-labelledby="headingSeven" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                            @if(empty($manufacturingHistory))
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No Manufacturing
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            @else
                            <div class="table-responsive">
                            <table class="table table-bordered table-striped m-0">
                            <thead>
                                            <tr>
                                            <th>Item</th>
                                            <th>Unit</th>
                                            <th>Quantity</th>
                                            <th>Cost of Manufacturing</th>
                                            <th>Remark</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($manufacturingHistory as $history)
                                            <tr>
                                            <td><strong>{{@strtoupper($history->item_name)}}</strong>
                                            <p><small>{{$history->created_at}}</small></p>
                                            </td>
                                            <td>{{$history->item_unit}}</td>
                                            <td>@convert($history->manufacturing_qty)</td>
                                            <td>@convert($history->rate)</td>
                                            <td>{{$history->manufacturing_comment}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                <!-- Faq end -->

                </div>
                <!-- Faq end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
        <div class="submit-request-card">
            <div>
                <h5 class="text-info">Opening Balance</h5>
                <p>The Current Opening Stock as at {{request('date')}}</p>
            </div>
            <button class="btn btn-outline-info rounded-pill" data-bs-toggle="modal" data-bs-target="#submitTicketModal">@convert(request('opening') == null ? $opening : request('opening'))</button>
</div>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
        <div class="submit-request-card">
            <div>
                <h5 class="text-info">Closing Stock</h5>
                <p>Current Closing Stock as at {{request('date')}}</p>
            </div>
            <a href="#" class="btn btn-outline-info rounded-pill">@convert(request('closing') == null ? $closing : request('closing'))</a>
        </div>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->
@endsection