@extends('layouts.fullscreen')

@section('content')


<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            
            <div class="card">
            <div class="card-header-lg">

            <h5>Inventory Items</h5>

                <span>
                    <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addNewDocument"><i class="icon-add"></i> New stock</button>
                    <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addBOMImport"><i class="icon-download1"></i> Import BOM</button>
                    

                    <a href="{{route('EditMenu')}}" class="btn btn-outline-secondary"><i class="icon-box"></i> POS Items </a>
                    
                    
                <!-- Modal start -->
                <div class="modal fade" id="addBOMImport" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Import Bill of material</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">

                                <div class="alert alert-light alert-dismissible fade show" role="alert">
                                It's a comprehensive list of all the components, parts, raw materials, and sub-assemblies required to manufacture or assemble a finished product. Provide detailed breakdown of the quantities and types of items needed to create a particular product. 
                                <p><strong>Note:</strong> This BOM is related to the basic stock unit</p>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>

                                    <form action="{{route('ImportBillOfMaterial')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <!-- Row start -->
										<div class="row gutters">
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<div class="input-group">														
														<input type="file" name="file" class="form-control" >
                                                        <div class="field-placeholder">Import BOM <span class="text-danger">*</span></div>
														<button class="btn btn-outline-primary" type="submit" >Upload</button>
													</div>
												</div>
												<!-- Field wrapper end -->

											</div>
										</div>
										<!-- Row end -->
                                    </form>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                    <!-- Modal end -->


                </span>
               
                <div class="modal fade" id="addNewDocument" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDocumentLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addNewDocumentLabel">Item Information</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">
                            <div class="alert alert-light alert-dismissible fade show" role="alert">
                            Generate and enroll a fresh stock or inventory item within the system.
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <div style="margin:12px">
                            <form action="{{route('ImportStock')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">														
                                                <input type="file" name="file" class="form-control" >
                                                <div class="field-placeholder">Import Items <span class="text-danger">*</span></div>
                                                <button class="btn btn-outline-primary" type="submit" >Upload</button>
                                            </div>
                                            <small class="text-mute"><a href="/uploads/Inventory_items_sample.csv">Download Sample</a></small>
                                        </div>
                                        <!-- Field wrapper end -->

                                    </div>
                                </div>
                                <!-- Row end -->
                            </form>
                            </div>

                                <form class="row gutters" action="{{route('addProduct')}}" method="post">
                                    @csrf
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" name="p_name" required>
                                            <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select  name="p_category" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                                <option disabled selected>Select Category</option>
                                                @foreach($categories as $category)
                                                <option>{{$category->category_name}}</option>
                                                @endforeach
                                            </select>
                                            <div class="field-placeholder">Category<span class="text-danger">*</span></div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                            <select class="select-single js-states" title="Select Term" data-live-search="true" name="item_unit">
                                                <option disabled selected>Select Unit</option>
                                                @foreach($units as $unit)
                                                <option>{{$unit->abbreviation}}</option>
                                                @endforeach
                                            </select>
                                            </div>
                                            <div class="field-placeholder">UOM<span class="text-danger">*</span></div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper m-0">
                                            <textarea class="form-control" name="p_description" rows="3"></textarea>
                                            <div class="field-placeholder">Description</div>
                                        </div>
                                        <!-- Field wrapper end -->


                                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="product_code"
                                                value="<?php echo "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi"); ?>"
                                                >
                                            </div>
                                            <div class="field-placeholder">Item code<span class="text-danger">*</span></div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" id="checkSms2" value="1" name="item_manufacturing">
                                        <label class="form-check-label" for="checkSms2">Manufacturing</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" id="checkSms2" value="1" name="transfer_status" checked>
                                        <label class="form-check-label" for="checkSms2">Transferable</label>
                                    </div>
                                    </div>

                                   
                                 <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-outline-primary">Proceed</button>
                                    </div>
                                </form>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  

            

                <div class="card-body">

                <div class="alert alert-light alert-dismissible fade show" role="alert">
                These are individual products, items, or goods that are tracked and managed within the system. These inventory items represent the specific units that a business buys, sells, produces, or stores.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Item</th>		
                                  <th>Category</th>	
                                  <th width="50%">Inactive Station
                                      <p><small>Stock will be disable at selected outlets</small></p>
                                  </th>
                                  <th>Type</th>	
                                  @if(auth()->user()->role == "Administrator")
                                    <th>Action</th>
                                  @endif 
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items->chunk(30) as $row)
                                @foreach($row as $item)
                                <tr>
                                  <td width="10%">
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{@ucwords(@strtolower($item->item_name))}} ({{@ucwords(@strtolower($item->item_unit))}})</a>
                                              <p>{{$item->item_code}}</p>
                                          </div>
                                      </div>
                                  </td>
                                  <td>{{@ucwords(@strtolower($item->item_category))}}</td>	
                                  <form action="{{route('updateItem', $item->id)}}" method="post">
                                      @csrf
                                  <td>
                                    <div class="field-wrapper">
                                        <select name="stations[]" class="select-multiple js-states" title="Select Product Category" multiple="multiple">
                                        @if(!empty($item->inactive_station))
                                        @foreach(json_decode($item->inactive_station) as $branch)
                                        <option selected>{{$branch}}</option>
                                        @endforeach
                                        @endif
                                        @foreach($warehouses as $warehouse)
                                        <option value="{{$warehouse->warehouse_name}}">{{@ucwords(@strtolower($warehouse->warehouse_name))}}</option>
                                        @endforeach
                                        @foreach($kitchens as $kitchen)
                                        <option value="{{$kitchen->kitchen_name}}">{{@ucwords(@strtolower($kitchen->kitchen_name))}}</option>
                                        @endforeach
                                        </select>
                                        <div class="field-placeholder">Station</div>
                                    </div>
                                  </td>
                                  <td>{!!$item->item_manufacturing == 1 ? '<span class="badge bg-success">' . "Manufacturing" . '</span>' : '<span class="badge bg-danger">' . "Unprocessed" . '</span>' !!}</td>												  
                                  @if(auth()->user()->role == "Administrator")
                                  <td>
                                            <a href="/dashboard/item-add-composing/<?= $item->id;?>/<?= $item->item_name?>" class="btn btn-default">
                                            <i class="icon-edit-2"></i>
                                            </a>
                                            <button type="submit" class="btn btn-default"><i class="icon-save"></i></button>
                                        
                                  </td>
                                  @endif
                                </form>
                                </tr>
                               @endforeach
                               @endforeach
                            </tbody>
                    </table>
                    </div>

                    {{$items->links()}}

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="advance" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Change Item BOM</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('changeBOM')}}" method="post">
                    @csrf
                <div class="row gutters">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
								
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                            <select class="select-single js-states" name="item" title="Select Product Category" data-live-search="true">
                                @foreach($items as $item)
                                    <option value="{{$item->id}} - {{$item->item_name}}">{{$item->item_name}}</option>
                                @endforeach
                                </select>
                            </div>
                            <div class="field-placeholder">Existing Item</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <select class="select-single js-states" name="replace_with" title="Select Product Category" data-live-search="true">
                                    @foreach($items as $item)
                                        <option value="{{$item->id}} - {{$item->item_name}} - {{$item->item_code}}">{{$item->item_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="field-placeholder">Replace With / Add Product</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="text" name="unit_measure" class="form-control">
                            </div>
                            <div class="field-placeholder">Unit Measure</div>
                            <small class="text-primary">Leave blank to maintain existing unit measure</small>
                        </div>
                        <!-- Field wrapper end -->
                    </div>

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input type="text" name="cost" class="form-control" required>
                            </div>
                            <div class="field-placeholder">Cost</div>
                        </div>
                        <!-- Field wrapper end -->
                    </div>

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <button type="submit" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                        <!-- Field wrapper end -->
                    </div>
                    
                </form>
            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->





<!--  Small modal example -->
<div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mySmallModalLabel"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h5>Composition</h5>
                    <hr>
                    <div id="demoB"></div>

                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->

@endsection