@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


    <!-- Breadcrumb container start -->
    <div class="breadcrumb-container">

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Manufacturing</li>
                    </ol>
                </nav>
            </div>

        </div>
        <!-- Row end -->

    </div>
    <!-- Breadcrumb container end -->
    <!-- Row start -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-body">

                    <div class="custom-tabs-container">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">Item Manufacturing</a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false">Correction(s)</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="first" role="tabpanel">

                            <div class="alert alert-light alert-dismissible fade show" role="alert">
                                It's the production of finished goods or products using raw materials, components, or sub-assemblies. It involves transforming these inputs through various production activities, such as assembly, fabrication, or processing, to create the final products that will be available for sale or distribution.
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        
                            <form action="{{route('ManufacturingPrepare')}}" id="manufacturing" method="POST">

                            <!-- Row start -->
										<div class="row gutters">
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper" style="width: 300px;">
													<div class="input-group">														
														<input type="date"  min="{{$dayClose->day_close}}" max="<?= $dayClose->day_close ?>" class="form-control" value="<?= $dayClose->day_close ?>" name="date">
													</div>
													<div class="field-placeholder">Select Date</div>
												</div>
												<!-- Field wrapper end -->

											</div>
                                        </div>

                                        @csrf
                                    
                                    <div class="table-responsive">
                                    <div class="table-container light-blue">
                                        <table class="table v-middle m-0">
                                                <thead>
                                                    <tr>
                                                    <th>Items</th>
                                                    <th>Item Code</th>
                                                    <th>UOM</th>
                                                    <th>Quantity</th>
                                                    <th>Remark</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($manufacturing as $me)
                                                    <tr>
                                                        <td>{{@ucwords(@strtolower($me->item_name))}}</td>
                                                        <td>{{$me->item_code}}</td>
                                                        <td>{{$me->item_unit}}</td>
                                                        <td>
                                                            <input type="number" min="0" step="0.0001" class="form-control" name="items[<?=$me->id;?>][item_qty]" value="">
                                                            <input type="text" class="form-control" name="items[<?=$me->id;?>][item_name]" value="{{$me->item_name}}" hidden>
                                                            <input type="text" class="form-control" name="items[<?=$me->id;?>][item_code]" value="{{$me->id}}" hidden>
                                                            <input type="text" class="form-control" name="items[<?=$me->id;?>][item_unit]" value="{{$me->item_unit}}" hidden>
                                                        </td>
                                                        <td><textarea name="items[<?=$me->id;?>][item_comment]" class="form-control"></textarea></td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                        </table>
                                        </div>

                                        <div style="margin-top:12px">
                                           <button class="btn btn-outline-primary" type="button" onclick="manufacture()"> <i class="icon-shopping-bag1"></i> Manufacture</button>
                                        </div>

                                 </form>

                            </div>
                            </div>
                            <div class="tab-pane fade" id="second" role="tabpanel">

                             <!-- Row start -->
										<div class="row gutters">
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
												<form action="{{route('ManCorrectDate')}}" method="get">
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<div class="input-group"  style="width: 300px;">														
														<input type="date" class="form-control" min="{{$dayClose->day_close}}" max="<?= $dayClose->day_close ?>" value="<?= $dayClose->day_close ?>" name="date">
                                                        <button class="btn btn-primary" type="submit">Search</button>
													</div>
													<div class="field-placeholder">Select Date</div>
												</div>
												<!-- Field wrapper end -->
                                                </form>
											</div>
                                        </div>
                                
                                <p class="text-muter">Manufacturing History</p>
                                <div class="table-container light-blue">
                                <table class="table v-middle m-0">
                                        <thead>
                                            <tr>
                                            <th>Item</th>
                                            <th>UOM</th>
                                            <th>Quantity</th>
                                            <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                            <th>Cost <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
                                            <th>Remark</th>
                                            <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $manTotal = 0 ; ?>
                                            @foreach($manufacturingHistory as $history)
                                            <tr>
                                            <td><strong style="font-weight:700">{{@ucwords(@strtolower($history->item_name))}}</strong>
                                            <p><small>{{$history->created_at}}</small></p>
                                            </td>
                                            <td>{{$history->item_unit}}</td>
                                            <td>{{$history->manufacturing_qty}}</td>
                                            <td>{{$history->rate}}</td>
                                            <td>{{$history->rate * $history->manufacturing_qty}}</td>
                                            <td>{{empty($history->manufacturing_comment) ? "No Comment" : $history->manufacturing_comment}}</td>
                                            <td>
                                                <div class="actions">
                                                    <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"  id="{{$history->id}}" onclick="deleteManufacturing(this.id)">
                                                        <i class="icon-x-circle text-danger"></i>
                                                    </a>
                                                </div>
                                            </td>
                                            </tr>
                                            <?php $manTotal += $history->rate * $history->manufacturing_qty ?>
                                            @endforeach
                                            <tr>
                                                <td>Total</td>
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td><span class="text-primary">@convert($manTotal)</span></td>
                                                <td></td>
                                                <td></td>
                                            </tr>
                                        </tbody>
                                </table>
                            </div>
                            
                        </div>
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->
</div>
						
                    
    </div>
    <!-- Content wrapper end -->



<script>
    function manufacture() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You will be consuming bill of materials for these items!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, manufacture!'
            }).then((result) => {
            if (result.isConfirmed) {
                $('#loading-wrapper').show();
                document.getElementById("manufacturing").submit();
            }
            })
    }



    function SelectManu() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You will be consuming bill of materials for these items!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, manufacture!'
            }).then((result) => {
            if (result.isConfirmed) {
                $('#loading-wrapper').show();
                document.getElementById("manufacturingSingle").submit();
            }
            })
    }



    function deleteManufacturing(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are deleting a manufactured stock, you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/reverse/manufacturing/"+id
            }
            })
    }
</script>      


@endsection