@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            
            <div class="card">
            <div class="card-header-lg">

            <h5>Product & Service - POS</h5>

                <span>
                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#addNewDocument33" class="btn btn-outline-primary"><i class="icon-add"></i> New Product </a>
                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addBOMImport"><i class="icon-download1"></i> Import BOM</button>

                <a href="{{route('productSettings')}}" class="btn btn-outline-secondary"> VIEW BOM's </a>
                    
    <!-- Modal start -->
    <div class="modal fade" id="addBOMImport" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalCenterTitle">Import Bill of Material</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                <div class="alert alert-light alert-dismissible fade show" role="alert">
                                It's a comprehensive list of all the components, parts, raw materials, and sub-assemblies required to manufacture or assemble a finished product. Provide detailed breakdown of the quantities and types of items needed to create a particular product.
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>

                                    <form action="{{route('ImportBillOfMaterial')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <!-- Row start -->
										<div class="row gutters">
											<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
												<!-- Field wrapper start -->
												<div class="field-wrapper">
													<div class="input-group">														
														<input type="file" name="file" class="form-control" >
                                                        <div class="field-placeholder">Import BOM <span class="text-danger">*</span></div>
														<button class="btn btn-outline-primary" type="submit" >Upload</button>
													</div>
												</div>
												<!-- Field wrapper end -->
                                                <small class="text-mute"><a href="/uploads/menu_bill_of_material.csv">Download Sample</a></small>
											</div>
										</div>
										<!-- Row end -->
                                    </form>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                    <!-- Modal end -->

                </span>
               
                <div class="modal fade" id="addNewDocument" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDocumentLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addNewDocumentLabel">Item Information</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">

                            <div style="margin:12px">
                            <form action="{{route('ImportStock')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">														
                                                <input type="file" name="file" class="form-control" >
                                                <div class="field-placeholder">Import Items <span class="text-danger">*</span></div>
                                                <button class="btn btn-outline-primary" type="submit" >Upload</button>
                                            </div>
                                            <small>Please download sample CSV</small>
                                        </div>
                                        <!-- Field wrapper end -->

                                    </div>
                                </div>
                                <!-- Row end -->
                            </form>
                            </div>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  

            

                <div class="card-body">


                <form action="{{route('SearchProduct')}}" method="get">
                    <!-- Row start -->
                    <div class="row justify-content-end">
                    
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">														
                                    <input type="text" class="form-control" placeholder="Search Product or service Here..." name="query">
                                    <button class="btn btn-primary" type="submit">Search</button>
                                </div>
                                <div class="field-placeholder">Quick Search</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                    
                    </div>
                    <!-- Row end -->
                </form>

                <div class="alert alert-light alert-dismissible fade show" role="alert">
                This is specific units or merchandise that are available for purchase by customers at the Point of Sales System. These items are typically tracked and managed within the POS system to facilitate sales transactions.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>

                <form action="{{route('makechangesMenu')}}" id="stockchange" method="post">
                    @csrf
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Products</th>		
                                  <th>CreatedAt</th>
                                  <th>Barcode</th>	
                                  <th>Category</th>
                                  <th>Ecommerce</th>												  
                                  <th>Rate</th>
                                  @if(auth()->user()->role == "Administrator")
                                  <th>Action</th>
                                  @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                  <td>
                                  <div class="media-box">
                                        <div class="media-box-body">
                                            @if(auth()->user()->role == "Administrator")
                                            <a href="/dashboard/product-add-composing/{{$item->FinalProductionID}}?item_name={{$item->Name}}" class="text-truncate">
                                                @else
                                                <a href="#" class="text-truncate">
                                                @endif
                                                {!!@strtoupper($item->Name)!!}</a>
                                            <p>ID: #{{@strtoupper($item->product_code)}}</p>
                                        </div>
                                    </div>
                                  </td>
                                  <td>{{$item->created_at}}</td>	
                                  <td>{{$item->barcode}}</td>
                                  <td>{{@strtoupper($item->production_category)}}</td>		
                                  <td>{!!$item->website_display == 1 ? '<span class="text-success"><i class="icon-check"></i>'." Enabled". '</span>' : '<span class="text-primary"><i class="icon-slash"></i>' . " Disabled" . '</span>'!!}</td>												  
                                  <td> 
                                    
                                  <input type="number" min="0" class="form-control" name="items[<?=$item->FinalProductionID;?>][price]" value="{{$item->UnitPrice}}">
                                  <input type="number" class="form-control" name="items[<?=$item->FinalProductionID;?>][menu_id]" value="{{$item->FinalProductionID}}" hidden>

                                  </td>
                                  <td>
                                  @if(auth()->user()->role == "Administrator")
                                    <form action="/dashboard/product-add-composing/<?=$item->FinalProductionID?>" method="get">
                                        <input type="text" name="item_name" hidden id="" value="<?= $item->Name ?>">
                                        <button class="btn btn-outline-default btn-sm waves-effect waves-light"><i class="icon-eye1"></i></button>
                                    </form>
                                  @endif
                                  </td>
                            
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                    {{$items->links()}}

                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12" style="margin-top:20px">
												
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                                <button class="btn btn-outline-primary" type="button" onclick="SaveMenu()">Save changes</button>
                            </div>
                        </div>
                        <!-- Field wrapper end -->

                      
                    </div>
                    </form>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->




@include('inc.add-product')
             
            

<script>
    function SaveMenu() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are saving changes made on a product, you may not be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, save!'
            }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("stockchange").submit();
            }
            })
    }
</script> 



@endsection