@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Satellite Station</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('kitchen.store')}}">
                @csrf  
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="kitchen_name" required>
                                <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                               
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="kitchen_location" required>
                                <div class="field-placeholder">Location<span class="text-danger">*</span></div>
                               
                            </div>
                            <!-- Field wrapper end -->
                            <input type="text" class="form-control" value="S" hidden name="kitchen_category" required>
                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Kitchens</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Name</th>
                        <th>Outlet Code</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($satellite_kitchen as $kitchen)
                        <tr>
                        <td>{{$kitchen->kitchen_name}}</td>
                        <td>{{$kitchen->kitchen_code}}</td>
                        <td>
                        <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                <a href="{{route('deleteKitchen', $kitchen->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection