<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Andas Solutions Back Office">
		<meta name="author" content="ADORABLE">
		<link rel="shortcut icon" href="/assets/img/{{$app->fav_icon}}">

		<!-- Title -->
		<title>{{$app->app_name}} - Andas Solutions - v.2.0.1</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">

	</head>

	
	<body>
		<!-- Loading wrapper start -->
		<div id="loading-wrapper" style="display:none">
			<div class="spinner-border"></div>
			@if(Route::currentRouteName() == "manufacturing" || Route::currentRouteName() == "ManCorrectDate")
				Manufacturing in Progress... Please Wait
			@else
				Loading... Please wait
			@endif
		</div>
		<!-- Loading wrapper end -->
		

		<!-- Page wrapper start -->
		<div class="page-wrapper">
			
			<!-- Sidebar wrapper start -->
			<nav class="sidebar-wrapper">

				<!-- Sidebar content start -->
				<div class="sidebar-tabs">

					<!-- Tabs nav start -->
					<div class="nav" role="tablist" aria-orientation="vertical">
						<a href="{{route('dashboard')}}" class="logo">
							<img src="/assets/img/{{$app->fav_icon}}" alt="Logo">
						</a>
						@if(auth()->user()->role != "Accountant")
						<a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#tab-home" role="tab" aria-controls="tab-home" aria-selected="true">
							<i class="icon-home2"></i>
							<span class="nav-link-text">Dashboards</span>
						</a>
						@endif
						
						@can('create', App\Models\User::class)
						<a class="nav-link" id="authentication-tab" data-bs-toggle="tab" href="#tab-payment" role="tab" aria-controls="tab-authentication" aria-selected="false">
							<i class="icon-attach_money"></i>
							<span class="nav-link-text">Bookkeeping</span>
						</a>
						@endcan

						@if(auth()->user()->role != "Accountant")
						<a class="nav-link" id="components-tab" data-bs-toggle="tab" href="#tab-components" role="tab" aria-controls="tab-components" aria-selected="false">
							<i class="icon-bar-chart"></i>
							<span class="nav-link-text">Report</span>
						</a>
						@endif

						
						@if(auth()->user()->role == "Administrator")
						<a class="nav-link" id="authentication-tab" data-bs-toggle="tab" href="#tab-authentication" role="tab" aria-controls="tab-authentication" aria-selected="false">
							<i class="icon-unlock"></i>
							<span class="nav-link-text">Authentication</span>
						</a>
						<a class="nav-link" id="forms-tab" data-bs-toggle="tab" href="#tab-forms" role="tab" aria-controls="tab-forms" aria-selected="false">
							<i class="icon-settings1"></i>
							<span class="nav-link-text">Settings</span>
						</a>
						<a class="nav-link settings" id="settings-tab" data-bs-toggle="tab" href="#tab-settings" role="tab" aria-controls="tab-authentication" aria-selected="false">
							<i class="icon-user1"></i>
							<span class="nav-link-text">Profile</span>
						</a>
						@endif
					</div>
					<!-- Tabs nav end -->

					<!-- Tabs content start -->
					<div class="tab-content">
								
						<!-- Chat tab -->
						<div class="tab-pane fade show active" id="tab-home" role="tabpanel" aria-labelledby="home-tab">

							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Dashboards
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									@if(auth()->user()->role != "Accountant")
									<ul class="tile-menu">
										<li>
											<a href="{{route('dashboard')}}" title="Home">
                                                <i class="icon-laptop"></i> Dashboard
                                            </a>
										</li>
										<li>
											<a href="#" title="Requisition" data-bs-toggle="modal" data-bs-target="#makeRequest"><i class="icon-send1"></i> Stock Request</a>
										</li>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#makeVoucher" title="Tansfer"><i class="icon-share-2"></i> Stock Transfer</a>
										</li>
										@if($app->main_warehouse == auth()->user()->station)
										<li>
											<a href="{{route('warehousedocks.index')}}" title="Receive Goods"><i class="icon-pin"></i> Goods Receipts</a>
										</li>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#PurchaseInvoice" title="New Purchase"><i class="icon-receipt"></i> Purchase</a>
										</li>
										<li>
											<a href="{{route('proforma.index')}}" title="Proforma"><i class="icon-receipt"></i> ProForma</a>
										</li>
										@endif
										
										<li>
											<a href="{{route('manufacturing')}}" title="Production"><i class="icon-shopping-bag1"></i> Manufacturing</a>
										</li>
										<li>
											<a href="{{route('itemstockledger.isl')}}" title="Item Stock Ledger"><i class="icon-file-text"></i> Item stock ledger</a>
										</li>
										<!-- <li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#stockledger"><i class="icon-book-open"></i> Stock Tracking</a>
										</li> -->
										<li>
											<a href="{{route('itemstockledger.trash')}}" title="Wastages"><i class="icon-trash"></i> Trash Bucket</a>
										</li>
										<li>
											<a href="{{route('itemstockledger.physicalstock')}}" title="Physical stock counting"><i class="icon-layers2"></i> Physical Stock</a>
										</li>
									
										
										
										@if(auth()->user()->role !== "Administrator")
										<li>
											<a href="{{route('PettyCash')}}" title="Petty Cash"><i class="icon-attach_money"></i> Petty Cash</a>
										</li>
										
										<li>
											<a href="{{route('expenses.index')}}" title="Expenses"><i class="icon-tag1"></i> Bill</a>
										</li>
										@endif
										@can('create', App\Models\User::class)
										<li>
											<a href="{{route('adjustment')}}" title="Stock Adjustment"><i class="icon-droplet"></i> Adjustment</a>
										</li>
										@endcan
										<!-- <li>
											<a href="{{route('purchase.index')}}"><i class="icon-swap"></i> Purchase</a>
										</li> -->
									</ul>
									@else

									<ul>
										<li>
											<a href="{{route('payaccount.index')}}">General Ledger</a>
										</li>
										<li>
											<a href="{{route('summaryAccount')}}">Account Summary</a>
										</li>
										<li>
											<a href="{{route('chartAccount')}}">Chart of Account</a>
										</li>
										<li>
											<a href="{{route('CashBanking')}}">Cash and Bank Account</a>
										</li>
										<li>
											<a href="{{route('income')}}">Receipts</a>
										</li>
										<li>
											<a href="{{route('paySupplier')}}">Payments</a>
										</li>
										<li>
											<a href="{{route('vendor.index')}}">Vendors</a>
										</li>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#PurchaseInvoice"> Purchase</a>
										</li>
										<li>
											<a href="{{route('expenses.index')}}">Bill</a>
										</li>
										
									</ul>


									@endif
								</div>
							</div>
							<!-- Sidebar menu ends -->

							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<a href="{{route('voucherIncoming')}}" class="red">
									<div class="bg-avatar">{{$transferCount->count()}}</div>
									<h5>Incoming Vouchers</h5>
								</a>
								
								<a href="{{route('KicthenDisplay')}}" class="blue">
									<div class="bg-avatar"> <i class="icon-local_pizza"></i> </div>
									<h5>Order Display</h5>
								</a>
							</div>
							<!-- Sidebar actions ends -->

						</div>
						

						<!-- Forms tab -->
						<div class="tab-pane fade" id="tab-forms" role="tabpanel" aria-labelledby="forms-tab">

							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Configuration
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<li class="list-heading">Warehouse & Stations</li>
										<li>
											<a href="{{route('kitchen.index')}}">Central Station</a>
										</li>
										<li>
											<a href="{{route('kitchen.satellite')}}">Satellite Station</a>
										</li>
										<li>
											<a href="{{route('warehouse.index')}}">Warehouse</a>
										</li>
										<li>
											<a href="{{route('outlets.index')}}">Outlet</a>
										</li>
									</ul>
									<ul>
										<li class="list-heading">Other Settings</li>
										<li>
											<a href="{{route('vendor.index')}}">Vendors</a>
										</li>
										<li>
											<a href="{{route('item.index')}}">Items</a>
										</li>
										@can('create', App\Models\User::class)
										<!-- <li>
                                            <a href="{{route('AdjustPurchase')}}">Stock & Cost</a>
                                        </li> -->
										@endcan
										<li>
                                            <a href="{{route('stockLimit')}}">Re-order Levels</a>
                                        </li>
										@can('create', App\Models\User::class)
										<li>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModalCenteredTax">Tax</a>
                                        </li>
										@endcan
										<li>
											<a href="{{route('category.index')}}">Category</a>
										</li>
										<li>
											<a href="{{route('brand.index')}}">Brands</a>
										</li>
										<li>
											<a href="{{route('index.dispatchItem')}}">Delivery Prices</a>
										</li>
										<li>
											<a href="{{route('celebrity.index')}}">Coupons</a>
										</li>
										<!-- <li>
											<a href="{{route('category.index')}}">Beneficiaries</a>
										</li> -->
										<li>
											<a href="{{route('unit.index')}}">Unit Measurement</a>
										</li>
										<li>
											<a href="{{route('paymentIndex')}}">Payment Methods</a>
										</li>
										<li>
											<a href="#">Expiring Item</a>
										</li>
									</ul>	
									<ul>
											<li class="list-heading"> Business Setup</li>
											<li>
												<a href="{{route('index.settings')}}">Basic Setup</a>
											</li>
											@if(auth()->user()->role =="Administrator")
											<li>
												<a href="#" data-bs-toggle="modal" data-bs-target="#exampleModalDayClose">Day Close</a>
											</li>
											<li>
												<a href="#" data-bs-toggle="modal" data-bs-target="#exampleModalDayPrevious">Day Reopen</a>
											</li>
											@endif
										</ul>								
								</div>
							</div>
							<!-- Sidebar menu ends -->
							
							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile red">
									<i class="icon-book"></i> Learn More
								</div>
							</div>
							<!-- Sidebar actions ends -->

						</div>
						
						<!-- Components tab -->
						<div class="tab-pane fade" id="tab-components" role="tabpanel" aria-labelledby="components-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Report
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
                                        <li>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#stockledger">Stock Tracking</a>
                                        </li>
										@if(auth()->user()->role == "Administrator")
										<li>
                                            <a href="{{route('cos.index')}}">Cost of Sales Analysis</a>
                                        </li>
										@else
										<li>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#cosforbranch">Cost of Sales Analysis</a>
                                        </li>
										@endif
										<li>
                                            <a href="{{route('issueRegister')}}">Issue Register</a>
                                        </li>
										<li>
                                            <a href="{{route('issueRecieved')}}">Issue Received</a>
                                        </li>
										<li>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#bonconsum">Raw Material Cons.</a>
                                        </li>
										<li>
                                            <a href="{{route('manufacturingCost')}}">Manufacturing Cost</a>
                                        </li>
										<li>
                                            <a href="{{route('WastageCost')}}">Wastage Cost</a>
                                        </li>
										<li>
                                            <a href="{{route('showAll.goods')}}"> Good Receipt</a>
                                        </li>
										<li>
                                            <a href="{{route('salesReport')}}"> Sales Report</a>
                                        </li>
										<li>
                                            <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#exampleModalCenteredRevenue"> Revenue Summary</a>
                                        </li>
										<li>
                                            <a href="{{route('HeldTransaction')}}"> Held  Transactions</a>
                                        </li>

									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->

							@if(auth()->user()->role == "Administrator")
                            <!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile danger">
									<i class="icon-bar-chart"></i><a href="{{route('BookkeepingRe')}}">All Reports</a></div>
									<!-- <a href=""  data-bs-toggle="modal" data-bs-target="#TopCustomer"></a> -->
							</div>
							<!-- Sidebar actions ends -->
							@endif

						</div>
						@if(auth()->user()->role == "Administrator" || "Accountant")
						<!-- Authentication tab -->
						<div class="tab-pane fade" id="tab-payment" role="tabpanel" aria-labelledby="payment">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Bookkeeping
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<li>
											<a href="{{route('payaccount.index')}}">General Ledger</a>
										</li>
										<li>
											<a href="{{route('summaryAccount')}}">Account Summary</a>
										</li>
										<li>
											<a href="{{route('chartAccount')}}">Chart of Account</a>
										</li>
										<li>
											<a href="{{route('CashBanking')}}">Cash and Bank Account</a>
										</li>
										<li>
											<a href="{{route('income')}}">Receipts</a>
										</li>
										<li>
											<a href="{{route('paySupplier')}}">Payments</a>
										</li>
										<li>
											<a href="{{route('vendor.index')}}">Vendors</a>
										</li>
										<li>
											<a href="#" data-bs-toggle="modal" data-bs-target="#PurchaseInvoice"> Purchase</a>
										</li>
										<li>
											<a href="{{route('expenses.index')}}">Bill</a>
										</li>

										<!-- <li>
											<a href="#">Rider Cash Out</a>
										</li> -->
										
									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->
							@endif
							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile blue">
									<a href="#" class="btn btn-light m-auto">Upgrade Account</a>
								</div>
							</div>
							<!-- Sidebar actions ends -->

						</div>

						@if(auth()->user()->role == "Administrator")
						<!-- Authentication tab -->
						<div class="tab-pane fade" id="tab-authentication" role="tabpanel" aria-labelledby="authentication-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Authentication
							</div>
							<!-- Tab content header end -->

							<!-- Sidebar menu starts -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-menu">
									<ul>
										<li>
											<a href="{{route('user.index')}}">Users</a>
										</li>
										<li>
											<a href="{{route('newUser')}}">New User</a>
										</li>
									</ul>
								</div>
							</div>
							<!-- Sidebar menu ends -->

							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile blue">
									<a href="pricing.html" class="btn btn-light m-auto">Upgrade Account</a>
								</div>
							</div>
							<!-- Sidebar actions ends -->

						</div>
						@endif
						
						<!-- Settings tab -->
						<div class="tab-pane fade" id="tab-settings" role="tabpanel" aria-labelledby="settings-tab">
							
							<!-- Tab content header start -->
							<div class="tab-pane-header">
								Settings
							</div>
							<!-- Tab content header end -->

							<!-- Settings start -->
							<div class="sidebarMenuScroll">
								<div class="sidebar-settings">
									<div class="accordion" id="settingsAccordion">
										<div class="accordion-item">
											<h2 class="accordion-header" id="genInfo">
												<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#genCollapse" aria-expanded="true" aria-controls="genCollapse">
													General Info
												</button>
											</h2>
											<div id="genCollapse" class="accordion-collapse collapse show" aria-labelledby="genInfo" data-bs-parent="#settingsAccordion">
											<form method="post" action="{{route('updateuser', auth()->user()->id)}}">
												@csrf
											<div class="accordion-body">
													<div class="field-wrapper">
														<input type="text" readonly name="username" value="{{auth()->user()->name}}" />
														<div class="field-placeholder">Full Name</div>
													</div>

													<div class="field-wrapper">
														<input type="email" name="useremail" value="{{auth()->user()->email}}" />
														<div class="field-placeholder">Email</div>
													</div>

													<div class="field-wrapper">
														<input type="text" readonly value="{{auth()->user()->station}}" />
														<div class="field-placeholder">Station</div>
													</div>
													<div class="field-wrapper m-0">
														<button type="submit" class="btn btn-primary stripes-btn">Save</button>
													</div>
												</div>
											</div>
											</form>
										</div>
										<div class="accordion-item">
											<h2 class="accordion-header" id="chngPwd">
												<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#chngPwdCollapse" aria-expanded="false" aria-controls="chngPwdCollapse">
													Change Password
												</button>
											</h2>
											<form action="{{route('changePassword', auth()->user()->id)}}" method="post">
                								@csrf
											<div id="chngPwdCollapse" class="accordion-collapse collapse" aria-labelledby="chngPwd" data-bs-parent="#settingsAccordion">
												<div class="accordion-body">
													<div class="field-wrapper">
														<input type="text" name="old_password" required>
														<div class="field-placeholder">Current Password</div>
													</div>
													<div class="field-wrapper">
														<input type="password" name="password" required>
														<div class="field-placeholder">New Password</div>
													</div>
													<div class="field-wrapper">
														<input type="password" name="password_confirmation" required>
														<div class="field-placeholder">Confirm Password</div>
													</div>
													<div class="field-wrapper m-0">
														<button class="btn btn-primary stripes-btn">Save</button>
													</div>

												</div>
											</div>
										</form>
										@if(auth()->user()->role == "Administrator")
										<div class="accordion-item">
											<h2 class="accordion-header" id="sidebarNotifications">
												<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#notiCollapse" aria-expanded="false" aria-controls="notiCollapse">
													Duplicates Transactions
												</button>
											</h2>
											<div id="notiCollapse" class="accordion-collapse collapse" aria-labelledby="sidebarNotifications" data-bs-parent="#settingsAccordion">
												<div class="accordion-body">
													<div class="list-group m-0">
														<form action="{{route('duplicates')}}">
														<div class="field-wrapper">
														<input type="text" name="station" readonly value="{{auth()->user()->station}}" />
														<div class="field-placeholder">Station</div>
														</div>
														<div class="field-wrapper m-0">
															<button type="submit" class="btn btn-primary stripes-btn">check</button>
														</div>
														</form>
													</div>
												</div>
											</div>
										</div>
										<div class="accordion-item">
											<h2 class="accordion-header" id="sidebarNotificationsSearch">
												<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#notiCollapsesear" aria-expanded="false" aria-controls="notiCollapse">
													Search Order
												</button>
											</h2>
											<div id="notiCollapsesear" class="accordion-collapse collapse" aria-labelledby="sidebarNotifications" data-bs-parent="#settingsAccordion">
												<div class="accordion-body">
													<div class="list-group m-0">
														<form action="{{route('SearchOrder')}}">
														<div class="field-wrapper">
														<input type="text" name="search"/>
														<div class="field-placeholder">Order number</div>
														</div>
														<div class="field-wrapper m-0">
															<button type="submit" class="btn btn-primary stripes-btn">search</button>
														</div>
														</form>
													</div>
												</div>
											</div>
										</div>
										@endif
									</div>
								</div>
							</div>
							<!-- Settings end -->

							<!-- Sidebar actions starts -->
							<div class="sidebar-actions">
								<div class="support-tile blue">
									<a href="account-settings.html" class="btn btn-light m-auto">Advance Settings</a>
								</div>
							</div>
							<!-- Sidebar actions ends -->
						</div>

					</div>
					<!-- Tabs content end -->

				</div>
				<!-- Sidebar content end -->
				
			</nav>
			<!-- Sidebar wrapper end -->

			<!-- *************
				************ Main container start *************
			************* -->
			<div class="main-container">

				<!-- Page header starts -->
				<div class="page-header">
					
					<!-- Row start -->
					<div class="row gutters">
						<div class="col-xl-8 col-lg-8 col-md-8 col-sm-6 col-9">

							<!-- Search container start -->
							<div class="search-container">

							<!-- Toggle sidebar start -->
							<div class="toggle-sidebar" id="toggle-sidebar">
								<i class="icon-menu"></i>
							</div>
							<!-- Toggle sidebar end -->

							<!-- Search input group start -->
							<div class="ui fluid category search">
								<div class="ui icon input">
									<input style="height:15px" type="text" placeholder="Search item..." id="searchItemBar">
									<i class="search icon icon-search1" onclick="SearchItem()"></i>
								</div>
								<div class="results"></div>
							</div>
							<!-- Search input group end -->
							</div>
							<!-- Search container end -->

						</div>
						<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-3">

							<!-- Header actions start -->
							<ul class="header-actions">
							<h5><strong style="font-weight:600">Back Office</strong></h5>

								@if(auth()->user()->role == "Administrator")
								<li class="dropdown">
									<a href="#" id="taskss" data-toggle="dropdown" aria-haspopup="true">
										<i class="icon-check-square"></i>
									</a>
									<div class="dropdown-menu dropdown-menu-end lrg" aria-labelledby="taskss">
										<div class="dropdown-menu-header">
											Voucher Approvals ({{$authorizeStatus->count()}})
										</div>
										<div class="customScroll">
											<ul class="activity">
												@foreach($authorizeStatus as $list)
												<li class="activity-list">
													<div class="detail-info">
														<p class="date">{{$list->name}} | {{$list->transaction_no}}</p>
														<p class="info">{{$list->issue_to}}</p>
														<a href="{{route('viewVoucherAuthorize', $list->transaction_no)}}" style="text-decoration:underline" class="text-primary" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
															view voucher
														</a>
													</div>
												</li>
												@endforeach
											</ul>
										</div>
									</div>
								</li>
								@endif
								<li class="dropdown">
									<a href="#" id="userSettings" class="user-settings" data-toggle="dropdown" aria-haspopup="true">
										<span class="avatar">
											<img src="/assets/img/user.svg" alt="User Avatar">
											<span class="status busy"></span>
										</span>
									</a>
									<div class="dropdown-menu dropdown-menu-end md" aria-labelledby="userSettings">
										<div class="header-profile-actions">
											@can('create', App\Models\User::class)
											<a href="{{route('index.settings')}}"><i class="icon-settings1"></i>Settings</a>
											@endcan
											<a class="dropdown-item" href="{{ route('logout') }}"
                                      		 onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
													<i class="icon-log-out1"></i> Logout
													</a>
											<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
												@csrf
											</form>
										</div>
									</div>
								</li>
							</ul>
							<!-- Header actions end -->

						</div>
					</div>
					<!-- Row end -->					
					@include('inc.errorfile')
				</div>
				<!-- Page header ends -->

				<!-- Content wrapper scroll start -->
				<div class="content-wrapper-scroll">
				
                     @yield('content')

					<!-- App footer start -->
					@include('inc.footer')
					<!-- App footer end -->
					@include('modal.branch-sales-analysis-app')
					@include('modal.day-close')
					@include('modal.day-previous')
					@include('modal.tax')
					@include('modal.revenue')
					@include('modal.request')
					@include('modal.bomconsumption')
					@include('modal.ledger-summary')
					
				</div>
				<!-- Content wrapper scroll end -->

			</div>
			<!-- *************
				************ Main container end *************
			************* -->

		</div>
		<!-- Page wrapper end -->
		


		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->

		<script>
			function SearchItem() {
				var item = document.getElementById('searchItemBar').value;

				window.location.href = "/dashboard/item-history/" + item;
			}
		</script>
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>
		
		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>

		<!-- Apex Charts -->
		@if(Route::currentRouteName() == "dashboard" || Route::currentRouteName() == "BookkeepingRe")
		
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		
		<script>
		var branch = <?php

		if (auth()->user()->role == "Administrator") {

			$dayClose = \DB::table('close_days')->first();
			echo \DB::table('invoices')->selectRaw('branch as branch, count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
			->whereDate('created_at', $dayClose->day_close)
			->whereIn('invoice_status', [1,2])
			->groupBy('branch')
			->OrderBy('invoice_total_price', 'DESC')
			->take(6)->pluck('branch');

		}else{
			
			$dayClose = \DB::table('close_days')->first();
			echo \DB::table('invoices')->selectRaw('branch as branch, count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
			->where('branch', auth()->user()->branch)
			->whereDate('created_at', $dayClose->day_close)
			->whereIn('invoice_status', [1,2])
			->groupBy('branch')
			->OrderBy('invoice_total_price', 'DESC')
			->take(6)->pluck('branch');

		}

		?>;

		var sales = <?php

			if (auth()->user()->role == "Administrator") {

				$dayClose = \DB::table('close_days')->first();
				echo \DB::table('invoices')->selectRaw('branch as branch,count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
				->whereDate('created_at', $dayClose->day_close)
				->whereIn('invoice_status', [1,2])
				->groupBy('branch')
				->OrderBy('invoice_total_price', 'DESC')
				->take(6)->pluck('invoice_total_price');

			}else {

				$dayClose = \DB::table('close_days')->first();
				echo \DB::table('invoices')->selectRaw('branch as branch,count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
				->where('branch', auth()->user()->branch)
				->whereDate('created_at', $dayClose->day_close)
				->whereIn('invoice_status', [1,2])
				->groupBy('branch')
				->OrderBy('invoice_total_price', 'DESC')
				->take(6)->pluck('invoice_total_price');
			}
			
		?>;


		var transactions = <?php

			$dayClose = \DB::table('close_days')->first();
			if (auth()->user()->role == "Administrator") {
				echo \DB::table('invoices')->selectRaw('branch as branch,count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
				->whereDate('created_at', $dayClose->day_close)
				->whereIn('invoice_status', [1,2])
				->groupBy('branch')
				->OrderBy('invoice_total_price', 'DESC')
				->take(6)->pluck('invoice_number');
			}else {
				echo \DB::table('invoices')->selectRaw('branch as branch,count(invoice_number) as invoice_number, sum(invoice_total_price) as invoice_total_price')
				->where('branch', auth()->user()->branch)
				->whereDate('created_at', $dayClose->day_close)
				->whereIn('invoice_status', [1,2])
				->groupBy('branch')
				->OrderBy('invoice_total_price', 'DESC')
				->take(6)->pluck('invoice_number');
			}
			
		?>;

		var options = {
			chart: {
				height: 370,
				type: 'bar',
				stacked: true,
				toolbar: {
				show: false
				},
				zoom: {
				enabled: true
				}
			},
			plotOptions: {
				bar: {
				horizontal: false,
				},
			},
			dataLabels: {
				enabled: true
			},
			series: [{
				name: 'Transactions',
				data: transactions
			},{
				name: 'Sales',
				data: sales
			}],
			xaxis: {
				categories: branch,
			},
			legend: {
				position: 'bottom',
				offsetY: 0,
			},
			grid: {
				borderColor: '#e0e6ed',
				strokeDashArray: 5,
				xaxis: {
				lines: {
					show: true
				}
				},   
				yaxis: {
				lines: {
					show: false,
				} 
				},
				padding: {
				top: 0,
				right: 0,
				bottom: 10,
				left: 10
				}, 
			},
			yaxis: {
				show: false,
			},
			fill: {
				opacity: 1
			},
			tooltip: {
				y: {
				formatter: function (val) {
					return  val
				}
				}
			},
			colors: ['#1273eb', '#68a8f8'],
			}
			var chart = new ApexCharts(
			document.querySelector("#sales"),
			options
			);
			chart.render();

		</script>


		<!-- Line Graphs -->
		<script src="{{asset('assets/vendor/apex/examples/line/basic-line-graph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>
		
		@endif

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
	

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>
		<!-- <script src="{{asset('assets/vendor/apex/custom/crm/sales.js')}}"></script> -->

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>

		@if(Route::currentRouteName() == "branchSales")
		<script>
			$( document ).ready(function() {

				let unconfirmed = <?= round($unconfirmed, 0) ;?>;
				let confirmed = <?= round($branch_total_general, 0) ;?>;
				let total_sales = <?= round($total_sales,0) ;?>;

				var unconfirmedPercentage = parseFloat((unconfirmed/(total_sales+unconfirmed) * 100).toFixed(2));
				var confirmedPercentage = parseFloat(((confirmed)/(total_sales+unconfirmed) * 100).toFixed(2));


				$("#weeklyEarnings").circliful({
					animation: 1,
					animationStep: 5,
					foregroundBorderWidth: 12,
					backgroundBorderWidth: 10,
					percent: confirmedPercentage,
					textStyle: 'font-size: 12px;',
					fontColor: '#1273eb',
					foregroundColor: '#1273eb',
					backgroundColor: '#efeff7',
					multiPercentage: 1,
					percentages: [10, 20, 30],
				});

				$("#monthlyEarnings").circliful({
					animation: 1,
					animationStep: 5,
					foregroundBorderWidth: 12,
					backgroundBorderWidth: 10,
					percent: unconfirmedPercentage,
					fontColor: '#ef503f',
					foregroundColor: '#ef503f',
					backgroundColor: '#efeff7',
					multiPercentage: 1,
					percentages: [10, 20, 30]
				});


				// With Icon
				$("#withIcon").circliful({
					animationStep: 5,
					foregroundBorderWidth: 12,
					backgroundBorderWidth: 7,
					percent: 3,
					fontColor: '#000000',
					foregroundColor: '#8796af',
					backgroundColor: 'rgba(0, 0, 0, 0.1)',
					icon: '\ea71',
					iconColor: '#8796af',
					iconPosition: 'middle',
					textBelow: true,
					animation: 1,
					animationStep: 1,
					start: 2,
					showPercent: 1,
				});

				});
		</script>
		@endif
		


		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>