@extends('layouts.app')

@section('content')

<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboards</a></li>
              <li class="breadcrumb-item"><a href="#">Requisition</a></li>
              @if(Route::currentRouteName() == "IncomingRequest")
              <li class="breadcrumb-item active" aria-current="page">Incoming Requisitions</li>
              @else
              <li class="breadcrumb-item active" aria-current="page">Outgoing Requisitions</li>
              @endif
            </ol>
        </nav>
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Top Actions - DateRange and Buttons -->
            <!-- Top Actions - DateRange and Buttons -->
            
            @if(Route::currentRouteName() == "IncomingRequest")
            <form action="{{route('getIncomingRequestReport')}}" method="get">
            @else
            <form action="{{route('getOutgoingRequestReport')}}" method="get">
            @endif
            <div class="d-flex justify-content-end">
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <div class="input-group">
                    <input type="text" class="form-control custom-daterange2" name="date">
                        <span class="input-group-text">
                        <i class="icon-calendar1"></i>
                        </span>
                    </div>
                </div>
                <!-- Field wrapper end -->
                <button class="btn btn-info"><i class="icon-download1"></i>Reports</button>
            </div>
            </form>
        </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <div style="margin-bottom:15px">
    @if(Route::currentRouteName() == "IncomingRequest")
    <a href="{{route('OutgoingRequest')}}" class="btn btn-outline-primary btn-sm">Outgoing Request</a>
    @else
    <a href="{{route('IncomingRequest')}}" class="btn btn-outline-primary btn-sm">Incoming Request</a>
    @endif
    </div>
        <div class="card">
            <div class="card-body">
            @if(Route::currentRouteName() == "IncomingRequest")
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Indent No.</th>
                              <th>Indent Date</th>
                              @if(Route::currentRouteName() == "IncomingRequest")
                              <th>From Store</th>	
                              @else
                              <th>To Store</th>	
                              @endif												  
                              <th>By User</th>													  
                              <th>Status</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                              <td>
                               #{{$list->transaction_number}}
                              </td>
                              <td>
                                {{$list->date}}
                              </td>
                              @if(Route::currentRouteName() == "IncomingRequest")
                              <td>
                              {{$list->station}}
                              </td>		
                              @else
                              <td>
                              {{$list->request_from}}
                              </td>	
                              @endif									  
                              <td>{{$list->entered_by}}</td>
                              <td>
                                  @if($list->status == 0)
                                  <span class="badge bg-success"> Rejected </span>
                                  @elseif($list->status == 1)
                                  <span class="badge bg-danger"> Approved </span>
                                  @else
                                  <span class="badge bg-info"> Pending </span>
                                  @endif
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('ViewRequest', $list->transaction_number)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                </div>
                @else
                <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                              <th>Indent No.</th>
                              <th>Indent Date</th>
                              @if(Route::currentRouteName() == "IncomingRequest")
                              <th>From Store</th>	
                              @else
                              <th>To Store</th>	
                              @endif														  
                              <th>By User</th>													  
                              <th>Status</th>
                              <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($lists as $list)
                            <tr>
                              <td>
                               #{{$list->transaction_number}}
                              </td>
                              <td>
                                {{$list->date}}
                              </td>
                              @if(Route::currentRouteName() == "IncomingRequest")
                              <td>
                              {{$list->station}}
                              </td>		
                              @else
                              <td>
                              {{$list->request_from}}
                              </td>	
                              @endif													  
                              <td>{{$list->entered_by}}</td>
                              <td>
                                  @if($list->status == 0)
                                  <span class="badge bg-success"> Rejected </span>
                                  @elseif($list->status == 1)
                                  <span class="badge bg-danger"> Approved </span>
                                  @else
                                  <span class="badge bg-info"> Pending </span>
                                  @endif
                              </td>
                              <td>
                              <div class="actions">
                                      <a href="{{route('ViewRequest', $list->transaction_number)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                          <i class="icon-edit1 text-info"></i>
                                      </a>
                                  </div>
                              </td>
                            </tr>
                            @endforeach
                        </tbody>
                </table>
                </div>
                @endif

            </div>
        </div>

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection