<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>{{$app->app_name}} - Voucher Receipt</title>

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('assets/fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('assets/fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('assets/vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('assets/vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('assets/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('assets/js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('assets/vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('assets/vendor/search-filter/custom-search-filter.css')}}">
	</head>


    <style>
         @media print {
                #back{
                    visibility: hidden;
                }
            }
    </style>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
            <a href="/dashboard/voucher/view-list/incoming" id="back" style="text-decoration:underline"><span class="badge bg-info">Return Back</span></a><br>
                <a href="{{route('voucherList')}}" class="logo">
                    <img src="/assets/img/{{$app->app_logo}}" alt="Logo" style="max-width:70px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

 <!-- Row start -->
 <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <h4><strong style="font-weight:400">{{@strtoupper("ISSUED VOUCHER")}}</strong><br></h5>
                    Voucher From: {{@strtoupper($details->station)}}<br>
                    Recieving Store: {{@strtoupper($details->issue_store)}}
                </address>

                <div class="invoice-num">
                    <div>ID: #{{$details->issue_transaction_id}}</div>
                    <div>Date: {{$details->issue_date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
            <th>Items</th>
            <th>Quantity</th>
            <th>UOM</th>
            <th>Rate <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
            <th>Amount <br><strong>{{empty($app->currency) ? "GHS" : $app->currency}}</strong></th>
        </tr>
    </thead>
    <tbody>
    <?php $sumTotalGoods = 0 ;?>
        @foreach($vouchering as $req)

        <?php 
            $sumTotalGoods += round(round($req->issue_rate, 2) * round($req->issue_quantity,2),2);
            $total = round($sumTotalGoods, 2);
         ?>
        <tr>
            <td>
                <p>{{@ucwords(@strtolower($req->issue_item))}} {{$req->rejected_status == 0 ? "[Rejected]" : ""}}</p>
            </td>
            <td>
                @convert($req->issue_quantity)
            </td>
            <td>{{$req->issue_unit}}</td>
            <td>
            @convert($rate = round($req->issue_rate, 2))
            </td>
            <td>
           @convert(round(($rate * $req->issue_quantity), 2))
            </td>
        </tr>
        @endforeach

        <tr>
            <td colspan="3">&nbsp;</td>
            <td>
                <p class="m-0">Amount</p>
                <p class="m-0">Discount</p>
                <p class="m-0">VAT</p>
                @if($rejected == 0)@else
                <p class="m-0">Rejected</p>
                @endif
                <h5 class="mt-2 text-danger">Bill Amount</h5>
            </td>
            <td>
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($total,2))</p>
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(0)</p>
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(0)</p>
                @if($rejected == 0)@else
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($rejected = round($rejected,2))</p>
                @endif
                <h5 class="mt-2 text-danger">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(round($total - $rejected,2))</h5>
            </td>
        </tr>
    </tbody>
	</table>
</div>
<?php $comment = \DB::table('issue_lists')->where('transaction_no',$details->issue_transaction_id)->first() ?>

<div style="margin-top:50px;font-size:15px">
                <address class="text-right">
                    <strong style="font-weight:400">Memo:</strong> {{@strtolower(@ucwords($comment->comment))}} <br>
                    <strong style="font-weight:400">Issued by:</strong> {{@ucwords(@strtolower($details->name))}} <br>
                    <strong style="font-weight:400">Received by: </strong> <span class="text-primary" style="text-decoration:underline">{{@ucwords(@strtolower($username == null ? "Not Recieved" : $username))}}</span><br>
                    <strong style="font-weight:400">Created on: </strong> {{$comment->created_at}}
                </address>
            </div>
</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets/js/jquery.min.js')}}"></script>
		<script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('assets/js/modernizr.js')}}"></script>
		<script src="{{asset('assets/js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('assets/vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('assets/vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('assets/vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('assets/vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('assets/vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('assets/vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('assets/vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('assets/vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('assets/vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('assets/vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('assets/vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('assets/vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('assets/vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('assets/vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('assets/vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('assets/vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('assets/vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('assets/vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('assets/vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('assets/js/main.js')}}"></script>

	</body>

</html>
