@extends('layouts.app')

@section('content')

        <!-- Content wrapper start -->
        <div class="content-wrapper">
                <form id="satellite">
                @csrf
                @if($check_request == null)
                <input type="text" name="r_transaction_id" hidden value="<?=  rand(5034,10034580)+rand(4580,10034580) . date("Yd") . date('Hi');?>">
                @else
                <input type="text" name="r_transaction_id" hidden value="{{$check_request -> r_transaction_id}}">
                @endif

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                        <!-- Card start -->
                        <div class="card">
                            <div class="card-header-lg">
                                <h4>Indent</h4>
                                <div class="text-end">
                                <a href="{{route('IncomingRequest')}}" class="btn btn-danger">Incoming Request</a>
                                    <a href="{{route('OutgoingRequest')}}" class="btn btn-light">Outgoing Request</a>
                                </div>
                            </div>
                            <div class="card-body">

            
                
                                    <!-- Row start -->
                <div class="row justify-content-between">

                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Indent Information</div>
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                @if($check_request == null)
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="r_store">
                                <option disabled selected>Select Category</option>
                                        @foreach($warehouses as $warehouse)
                                        <option <?php if ($warehouse->warehouse_name == auth()->user()->station) { ?> disabled <?php } ?>>{{$warehouse->warehouse_name}}</option>
                                        @endforeach
                                        @foreach($kitchens as $kitchen)
                                        <option <?php if ($kitchen->kitchen_name == auth()->user()->station) { ?> disabled <?php } ?>>{{$kitchen->kitchen_name}}</option>
                                        @endforeach
                                </select>
                                @else
                                <select class="select-single js-states" title="Select Term" data-live-search="true" name="r_store">
                                <option selected>{{$check_request->r_store}}</option>
                                </select>
                                @endif
                                <div class="field-placeholder">Store <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="date" class="form-control" name="r_date" value="<?= $dayClose->day_close ?>">
                                </div>
                                <div class="field-placeholder">Date</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea name="r_note" id="" cols="30" rows="2" name="r_note"></textarea>
                                <div class="field-placeholder">Note</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                    </div>
                    <!-- Row end -->

                </div>
                <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Item Information</div>
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" name="r_category" title="Select Term" data-live-search="true">
                                    <option disabled selected>Select Category</option>
                                    @foreach($categories as $category)
                                    <option>{{$category->category_name}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Category</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" id="item" name="r_item" title="Select Term" data-live-search="true">
                                <option disabled selected>Select Item</option>
                                @foreach($items as $item)
                                    <option value="{{$item -> item_name}} - {{$item -> id}}">{{$item->item_name}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Item</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="number" class="form-control" step="0.001" name="r_quantity" id="quantity">
                                </div>
                                <div class="field-placeholder">Quantity</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" title="Select Term" id="unit" name="r_unit" data-live-search="true">
                                    <option disabled selected>Select Unit</option>
                                    @foreach($units as $unit)
                                    <option>{{$unit->abbreviation}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Unit</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <button class="btn btn-primary"><i class="fa fa-cart-plus" aria-hidden="true"></i> Add to Cart</button> 
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                    </div>
                    <!-- Row end -->

                </div>

                </div>
                <!-- Row end -->
              </form>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="tabler">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Sr#</th>
                                        <th>Item Name</th>
                                        <th>Quantity</th>
                                        <th>Unit</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($item_re as $re)
                                    <tr>
                                        <td>{{$re->id}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{$re->r_item}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="number" value="{{$re->r_quantity}}" class="form-control" placeholder="Qty" name="">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" value="{{$re->r_unit}}" class="form-control">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button type="button" id="{{$re->id}}" onclick="DeleteRequest(this.id)" class="btn btn-light">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                                
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
                <!-- Row end -->

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button type="button" class="btn btn-light ms-1" onclick="confirmIndentPrint()">Save & Print</button>
                                <button type="button" class="btn btn-primary ms-1" onclick="confirmIndent()">Save</button>
                                <button type="button" class="btn btn-danger ms-1" onclick="confirmClose()">Close</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
     $("#satellite").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('satelliteRequest.store')}}",
                dataType: "json",
                data: $('#satellite').serialize(),
                success: function(data){
                    // document.getElementById('ddlViewBy').value = "";
                    $("#tabler").load(" #tabler");
                    // $("#dis").load(" #dis");
                    // $("#disinf").load(" #disinf");
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });




        function confirmIndent() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveSatelliteRequest')}}";
            }
            })
    }



    function confirmIndentPrint() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveSatelliteRequestPrint')}}";
            }
            })
    }



    function DeleteRequest(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/request/delete-requisition/"+id);
            xhttp.send();
    }


    function confirmClose() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Clear Current Transaction!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearRequestSatellite')}}";
            }
            })
    }
</script>

@endsection