@extends('layouts.app')

@section('content')

	<!-- Content wrapper start -->
    <div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <!-- Card start -->
        <div class="card">
            <div class="card-header-lg">
                <h4>Authorize Quantity</h4>
                <div class="text-end">
                    <a href="#" class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#makeRequest">Make Request</a>
                </div>
            </div>
            <div class="card-body">
            <?php $check_status = \DB::table('request_lists')->where('transaction_number', $details->r_transaction_id)->first() ?>
                <div class="invoice-container">

                    <div class="invoice-header">
                        <!-- Row start -->
                        <div class="row justify-content-between">
                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                <p>Indent Information</p>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>

                    <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="invoice-details">
                                <address class="m-0">
                                    @if($check_status->station == auth()->user()->station)
                                        <strong>Requisition From:</strong><br>
                                        {{@ucwords(@strtolower($details->r_store))}}<br>
                                    @else
                                        <strong>Indent From:</strong><br>
                                        {{@ucwords(@strtolower($check_status->station))}}<br>
                                    @endif
                                    <strong>by</strong> <strong style="font-weight:500">{{@ucwords(@strtolower($check_status->entered_by))}}</strong>
                                </address>

                                <div class="invoice-num">
                                    <div>Indent No. - #{{$details->r_transaction_id}} 
                                        <input type="text" value="{{$details->r_transaction_id}}" id="transact" hidden>
                                    </div>
                                    <div>{{$details->r_date}}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Row end -->

                    <form action="{{route('authorizeRequisition')}}" id="AcceptStock" method="POST">
                        @csrf
                        <input type="text" value="{{$details->r_transaction_id}}" hidden name="transaction_number">
                        <input type="text" value="{{$details->r_date}}" hidden name="date">
                        <input type="text" value="{{$details->station}}" hidden name="recieving_store">

                        <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-12">
                            
                            <div class="table-responsive" id="tabler">
                                <table class="table v-middle m-0">
                                    <thead>
                                        <tr>
                                            <th>Items</th>
                                            <th>Stock Available</th>
                                            <th>UOM</th>
                                            <th>Requested Qty</th>
                                            <th>State</th>
                                            @if($check_status->station !== auth()->user()->station)
                                            <th>Issue Qty</th>
                                            @if($check_status->status != 1)
                                            <th>Action</th>
                                            @endif
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($requistion as $req)
                                        <?php 
        
                                                $to =  $req->r_date;
                                                $from =  $req->r_date;


                                                $balance_b_f =  \DB::table('item_stock_ledger_summaries')->where('station', $req->r_store)->where('item_id', $req->r_item_id)->whereDate('date', $req->r_date)->first();

                                                if (empty($balance_b_f)) {
                                                    $balance_b_f = 0;
                                                }else {
                                                    $balance_b_f = $balance_b_f->opening_stock;
                                                }
                                                
                                                

                                                $stock_in =  \DB::table('stock_transactions')->where('station', $req->r_store)->where('item_id', $req->r_item_id)
                                                                            ->WhereDate('date', $from)
                                                                            ->WhereDate('date', $to)
                                                                            ->sum('stock_in');
                                                                            
                                                $stock_out =  \DB::table('stock_transactions')->where('station', $req->r_store)->where('item_id', $req->r_item_id)
                                                ->WhereDate('date', $from)
                                                ->WhereDate('date', $to)
                                                ->sum('stock_out');


                                                $Current_balance = ($stock_in - $stock_out) + $balance_b_f;
                                         ?>
                                        <tr>
                                            <td>
                                                <p>{{@ucwords(@strtolower($req->r_item))}}</p>
                                            </td>
                                            <td>@convert($current_stock = $Current_balance)</td>
                                            <td>{{$req->r_unit}}</td>
                                            <td>@convert($req->authorize_qty) </td>
                                            <td>
                                                    @if($req->authorize_qty > $current_stock)
                                                        <span class="text-danger">Out of stock</span>
                                                    @else
                                                    <span class="text-primary">In Stock</span>
                                                    @endif
                                            </td>
                                            @if($check_status->station !== auth()->user()->station)
                                            <td>
                                                <input type="number" class="form-control" min="0" name="items[<?=$req->id;?>][issue_qty]" value="{{$req->r_quantity}}">
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_date]" value="{{$req->r_date}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item]" value="{{$req->r_item}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_category]" value="{{$req->r_category}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_station]" value="{{$req->r_store}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_recieved_station]" value="{{$req->station}}"hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_item_id]" value="{{$req->r_item_id}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_note]" value="{{$req->r_note}}" hidden>
                                                <input type="text" class="form-control" name="items[<?=$req->id;?>][issue_unit]" value="{{$req->r_unit}}" hidden>
                                            </td>
                                            @if($check_status->status != 1)
                                            <td><a href="#" style="text-decoration:underline; color:red" id="{{$req->id}}" onclick="confirmRemove(this.id)">Remove</a></td>
                                            @endif
                                            @endif
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <?php $comment = \DB::table('request_lists')->where('transaction_number',$details->r_transaction_id)->first() ?>

                            

                        </div>
                        
                    </div>
                    <!-- Row end -->
                    
                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="text-start" style="margin-top:10px">
                                
                                @if($check_status->status == 1)
                                <button type="button" disabled class="btn btn-danger"> <i class="icon-check" aria-hidden="true"></i> Accepted & Confirmed</button>
                                @else
                                @if($check_status->user_id !== auth()->user()->id)
                                <button type="button" class="btn btn-outline-info" onclick="AcceptSt()">Accept & Issue</button>
                                @endif
                                @endif
                                @if($check_status->user_id == auth()->user()->id)
                                @if($check_status->status !== 1)
                                <!-- <button class="btn btn-danger ms-1" type="button"  onclick="makeChanges()">Make Changes</button> -->
                                @endif
                                @endif
                                <a style="float:right" href="/dashboard/request/incoming/view-requisition/print/{{$details->r_transaction_id}}" type="button" class="btn btn-outline-primary"> <i class="icon-print" aria-hidden="true"></i> Print</a>
                            </div>
                        </div>

                    </div>
                    <!-- Row end -->

                    </form>
                
                </div>

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
    function makeChanges() {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to make changes in your Requistion!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Make Change it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/dashboard/request/make-change-requestion/" + document.getElementById('transact').value;
            }
            })
    }
</script>


<script>
    function AcceptSt() {
        Swal.fire({
            title: 'Are you sure?',
            text: "Requistion may not go through if an item is out of stock, kindly remove items if needed!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, accept & Issue!'
            }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById("AcceptStock").submit();
            }
            })
    }



    function confirmRemove(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to delete item from list",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#tabler").load(" #tabler");
                }
                xhttp.open("GET",  "/dashboard/request/delete/" + id);
                xhttp.send();
            }
            })
    }
</script> 


@endsection