@extends('layouts.app')

@section('content')

        <!-- Content wrapper start -->
        <div class="content-wrapper">
                <form id="satellite">
                @csrf

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                        <!-- Card start -->
                        <div class="card">
                            <div class="card-header-lg">
                                <h4>Indent</h4>
                                <div class="text-end">
                                <a href="{{route('IncomingRequest')}}" class="btn btn-outline-danger">Incoming Request</a>
                                    <a href="{{route('OutgoingRequest')}}" class="btn btn-outline-light">Outgoing Request</a>
                                </div>
                            </div>
                 <div class="card-body">

                    <div class="alert alert-light alert-dismissible fade show" role="alert">
                            It's a formal request or requisition made by {{auth()->user()->station}}  to procure specific items or materials from the stock or {{request('r_store')}}. An indent is used to initiate the process of obtaining the required goods to fulfill organizational needs.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                
                                    <!-- Row start -->
                <div class="row justify-content-between">

                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Indent Information</div>
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" readonly type="text" name="r_store" value="{{request('r_store')}}">
                                <div class="field-placeholder">Request From <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="date" readonly class="form-control" name="r_date" value="<?= session()->get('date') ?>">
                                </div>
                                <div class="field-placeholder">Date</div>
                            </div>
                            <!-- Field wrapper end -->
                            
                        </div>

                    </div>
                    <!-- Row end -->

                </div>
                <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">

                    <!-- Row start -->
                    <div class="row gutters">

                        <div class="col-12">
                            <div class="form-section-header light-bg">Item Information</div>
                        </div>
                        
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="select-single js-states" id="item" name="r_item" title="Select Term" data-live-search="true">
                                <option disabled selected>- Select Item -</option>    
                                @foreach($items as $item)
                                    <option value="{{$item -> item_name}} - {{$item -> id}}">{{@ucwords(@strtolower($item->item_name))}}</option>
                                    @endforeach
                                </select>
                                <div class="field-placeholder">Item<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <div class="input-group">
                                    <input type="number" class="form-control" id="qty" step="0.001" name="r_quantity" id="quantity">
                                </div>
                                <div class="field-placeholder">Quantity<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>
                        

                        <input type="text" id="unit" name="r_unit" hidden>

                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <button class="btn btn-outline-primary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                    </div>
                    <!-- Row end -->

                </div>

                </div>
                <!-- Row end -->
              </form>

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-12" id="tabler">
                    @if(empty($item_re))
                    <!-- Card start -->
                    <div class="card">
                        <div class="card-body">
                            <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    No item added to cart. Kindly select Item and add to cart
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            
                        </div>
                    </div>
                    <!-- Card end -->
                    @else  
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th colspan="7" class="pt-3 pb-3">Item Details</th>
                                    </tr>
                                    <tr>
                                        <th>Sr#</th>
                                        <th>Item Name</th>
                                        <th>Quantity</th>
                                        <th>Unit</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($item_re as $re)
                                    <tr>
                                        <td>{{$re['id']}}</td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <select class="select-single js-states w-100" data-live-search="true">
                                                    <option>{{@ucwords(@strtolower($re['r_item']))}}</option>
                                                </select>
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="number" value="{{$re['r_quantity']}}" readonly class="form-control" placeholder="Qty" name="">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                        <td>
                                            <!-- Field wrapper start -->
                                            <div class="field-wrapper m-0">
                                                <input type="text" value="{{$re['r_unit']}}" readonly class="form-control">
                                            </div>
                                            <!-- Field wrapper end -->
                                        </td>
                                       
                                        <td>
                                            <div class="table-actions">
                                                <button type="button" id="{{$re['id']}}" onclick="DeleteRequest(this.id)" class="btn btn-outline-light">
                                                    <i class="icon-trash-2"></i>
                                                </button>
                                                
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                
                                </tbody>
                            </table>
                            
                        </div>
                        
                    @endif
                    <div class="row gutters">
                        <textarea class="form-control" onchange="editNote()" name="r_note" id="noteText" cols="30" rows="4" name="r_note" placeholder="Memo here"></textarea>
                    </div>
                    </div>

                    
                </div>
                <!-- Row end -->
                

                <!-- Row start -->
                <div class="row gutters">

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="form-actions-footer">
                            <div class="text-end">
                                <button type="button" class="btn btn-outline-primary ms-1" onclick="confirmIndentPrint()">Save & Print</button>
                                <!-- <button type="button" class="btn btn-primary ms-1" onclick="confirmIndent()">Save</button> -->
                                <button type="button" class="btn btn-danger ms-1" onclick="confirmClose()">Close</button>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- Row end -->

            </div>
        </div>
        <!-- Card end -->

    </div>
</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<script>
     $("#satellite").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('satelliteRequest.store')}}",
                dataType: "json",
                data: $('#satellite').serialize(),
                success: function(data){
                    // document.getElementById('ddlViewBy').value = "";
                    $("#tabler").load(" #tabler");
                    document.getElementById('qty').value = "";
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });




        function confirmIndent() {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save it!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveSatelliteRequest')}}";
            }
            })
    }


    function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/dashboard/customer-note/" + note);
            xhttp.send();
        }



    function confirmIndentPrint() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are making a requisition, you may not be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, request !'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('saveSatelliteRequestPrint')}}";
            }
            })
    }



    function DeleteRequest(id) {
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/dashboard/request/delete-requisition/"+id);
            xhttp.send();
    }


    function confirmClose() {
        Swal.fire({
            title: 'Are you sure?',
            text: "you are voiding the requisition, you won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, void!'
            }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{route('clearRequestSatellite')}}";
            }
            })
    }
</script>

@endsection