

<!-- Modal start -->
<div class="modal fade" id="exampleModalDayClose" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">End Day</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="dayclose" method="post">
                    @csrf

                <!-- Field wrapper start -->
                <div class="field-wrapper">
                   
                    <select class="select-single js-states" title="Select Term" data-live-search="true" name="station">
                    @if(auth()->user()->role == "Administrator")
                    <option disabled selected>Select Category</option>
                            @foreach($warehouses as $warehouse)
                            <option>{{$warehouse->warehouse_name}}</option>
                            @endforeach
                            @foreach($kitchens as $kitchen)
                            <option>{{$kitchen->kitchen_name}}</option>
                            @endforeach
                    @else
                        <option>{{auth()->user()->station}}</option>
                    @endif
                    </select>
                    
                    <div class="field-placeholder">Store<span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

                
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="date" class="form-control" name="date" value="<?= $dayClose->day_close ?>">
                        <button class="btn btn-primary">Submit</button>
                    </div>
                    <div class="field-placeholder">Datepicker</div>
                </div>
                <!-- Field wrapper end -->
                </form>
                <hr>
                <div class="field-wrapper">
                    <a href="{{route('closeday.index')}}" class="text-info">Verify system date for outlets</a>
                </div>
            </div>
            <div class="modal-footer">
                <a href="{{route('AccountTransaction')}}"  class="btn btn-outline-info"><i class="icon-link-2"></i> Link Transactions</a>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<script>
    $("#dayclose").on('submit', function(event) {
        $('#loading-wrapper').show();
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('day.close')}}",
                dataType: "json",
                data: $('#dayclose').serialize(),
                success: function(data){
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 5000,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                        })
                        if (data[0] == 0) {
                            $('#loading-wrapper').hide();
                            Swal.fire({
                                icon: 'error',
                                title: 'Oops...',
                                text: 'Day Alright Closed!',
                                footer: 'KINDLY CHECK CURRENT STATUS OF ' + data[1]
                                })
                        }else{
                            $('#loading-wrapper').hide();
                            Toast.fire({
                            icon: 'success',
                            title: 'Day closed Successfully at ' + data[0]
                            })
                        }
                },
                error: function(data){
                    $('#loading-wrapper').hide();
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


</script>